/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TranslatableComponent;
import org.jetbrains.annotations.NotNull;

public class TraderArgument
implements ArgumentType<TraderData> {
    private static final SimpleCommandExceptionType ERROR_NOT_FOUND = new SimpleCommandExceptionType((Message)new TranslatableComponent("command.argument.trader.notfound"));
    private final boolean acceptPersistentIDs;

    private TraderArgument(boolean acceptPersistentIDs) {
        this.acceptPersistentIDs = acceptPersistentIDs;
    }

    public static TraderArgument trader() {
        return new TraderArgument(false);
    }

    public static TraderArgument traderWithPersistent() {
        return new TraderArgument(true);
    }

    public static TraderData getTrader(CommandContext<CommandSourceStack> commandContext, String name) throws CommandSyntaxException {
        return (TraderData)commandContext.getArgument(name, TraderData.class);
    }

    public TraderData parse(StringReader reader) throws CommandSyntaxException {
        String traderID = reader.readUnquotedString();
        if (TraderArgument.isNumerical(traderID)) {
            try {
                TraderData t;
                long id = Long.parseLong(traderID);
                if (id >= 0L && (t = TraderSaveData.GetTrader(false, id)) != null) {
                    return t;
                }
            }
            catch (Throwable id) {
                // empty catch block
            }
        }
        if (this.acceptPersistentIDs) {
            List<TraderData> allTraders = TraderSaveData.GetAllTraders(false);
            for (TraderData t : allTraders) {
                if (!t.isPersistent() || !t.getPersistentID().equals(traderID)) continue;
                return t;
            }
        }
        throw ERROR_NOT_FOUND.createWithContext((ImmutableStringReader)reader);
    }

    private static boolean isNumerical(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        List<TraderData> allTraders = TraderSaveData.GetAllTraders(false);
        for (TraderData t : allTraders) {
            suggestionsBuilder.suggest(String.valueOf(t.getID()));
            if (!this.acceptPersistentIDs || !t.isPersistent()) continue;
            suggestionsBuilder.suggest(t.getPersistentID());
        }
        return suggestionsBuilder.buildFuture();
    }

    public static class Info
    implements ArgumentSerializer<TraderArgument> {
        public void serializeToNetwork(TraderArgument argument, FriendlyByteBuf buffer) {
            buffer.writeBoolean(argument.acceptPersistentIDs);
        }

        @NotNull
        public TraderArgument deserializeFromNetwork(FriendlyByteBuf buffer) {
            return new TraderArgument(buffer.readBoolean());
        }

        public void serializeToJson(TraderArgument argument, JsonObject json) {
            json.addProperty("acceptPersistentIDs", Boolean.valueOf(argument.acceptPersistentIDs));
        }
    }
}

