/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.core.variants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.Tags;

public enum Color {
    WHITE("White", 0, 0xFFFFFF, MaterialColor.f_76406_, (TagKey<Item>)Tags.Items.DYES_WHITE),
    LIGHT_GRAY("Light Gray", 1, 0x9D9D97, MaterialColor.f_76420_, (TagKey<Item>)Tags.Items.DYES_LIGHT_GRAY, "lightgray"),
    GRAY("Gray", 2, 0x646464, MaterialColor.f_76419_, (TagKey<Item>)Tags.Items.DYES_GRAY),
    BLACK("Black", 3, 0x141414, MaterialColor.f_76365_, (TagKey<Item>)Tags.Items.DYES_BLACK),
    BROWN("Brown", 4, 8606770, MaterialColor.f_76362_, (TagKey<Item>)Tags.Items.DYES_BROWN),
    RED("Red", 5, 0xFF0000, MaterialColor.f_76364_, (TagKey<Item>)Tags.Items.DYES_RED),
    ORANGE("Orange", 6, 0xFF7F00, MaterialColor.f_76413_, (TagKey<Item>)Tags.Items.DYES_ORANGE),
    YELLOW("Yellow", 7, 0xFFFF00, MaterialColor.f_76416_, (TagKey<Item>)Tags.Items.DYES_YELLOW),
    LIME("Lime", 8, 8834086, MaterialColor.f_76417_, (TagKey<Item>)Tags.Items.DYES_LIME),
    GREEN("Green", 9, 32512, MaterialColor.f_76363_, (TagKey<Item>)Tags.Items.DYES_GREEN),
    CYAN("Cyan", 10, 1481628, MaterialColor.f_76421_, (TagKey<Item>)Tags.Items.DYES_CYAN),
    LIGHT_BLUE("Light Blue", 11, 65535, MaterialColor.f_76415_, (TagKey<Item>)Tags.Items.DYES_LIGHT_BLUE, "lightblue"),
    BLUE("Blue", 12, 255, MaterialColor.f_76361_, (TagKey<Item>)Tags.Items.DYES_BLUE),
    PURPLE("Purple", 13, 9913293, MaterialColor.f_76422_, (TagKey<Item>)Tags.Items.DYES_PURPLE),
    MAGENTA("Magenta", 14, 14049489, MaterialColor.f_76414_, (TagKey<Item>)Tags.Items.DYES_MAGENTA),
    PINK("Pink", 15, 16036553, MaterialColor.f_76418_, (TagKey<Item>)Tags.Items.DYES_PINK);

    public final String displayName;
    private final int sortIndex;
    public final int hexColor;
    public final MaterialColor mapColor;
    private final String deprecatedName;
    public final TagKey<Item> dyeTag;
    private static List<Color> deprecatedValues;

    public final String getResourceSafeName() {
        return this.toString().toLowerCase(Locale.ROOT);
    }

    public final boolean hasDeprecatedName() {
        return this.deprecatedName != null;
    }

    public final String getDeprecatedName() {
        return this.hasDeprecatedName() ? this.deprecatedName : this.toString();
    }

    private Color(String displayName, @Nonnull int sortIndex, @Nonnull int hexColor, @Nullable MaterialColor mapColor, TagKey<Item> dyeTag, String deprecatedName) {
        this.displayName = displayName;
        this.sortIndex = sortIndex;
        this.hexColor = hexColor;
        this.mapColor = mapColor;
        this.dyeTag = dyeTag;
        this.deprecatedName = deprecatedName;
    }

    private Color(String displayName, @Nonnull int sortIndex, @Nonnull int hexColor, MaterialColor mapColor, TagKey<Item> dyeTag) {
        this(displayName, sortIndex, hexColor, mapColor, dyeTag, null);
    }

    public static Color getFromIndex(long index) {
        index %= 16L;
        for (Color c : Color.values()) {
            if ((long)c.sortIndex != index) continue;
            return c;
        }
        return WHITE;
    }

    @Nullable
    public static Color getFromPrettyName(String name) {
        for (Color c : Color.values()) {
            if (!c.toString().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    public static int sortByColor(Color c1, Color c2) {
        return Integer.compare(c1.sortIndex, c2.sortIndex);
    }

    public static Collection<Color> deprecatedValues() {
        if (deprecatedValues == null) {
            deprecatedValues = new ArrayList<Color>();
            for (Color c : Color.values()) {
                if (!c.hasDeprecatedName()) continue;
                deprecatedValues.add(c);
            }
        }
        return deprecatedValues;
    }

    static {
        deprecatedValues = null;
    }
}

