/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.emergency_ejection;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.data.ClientEjectionData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.network.message.emergencyejection.SPacketSyncEjectionData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class EjectionSaveData
extends SavedData {
    private final List<EjectionData> emergencyEjectionData = new ArrayList<EjectionData>();

    private EjectionSaveData() {
    }

    private EjectionSaveData(CompoundTag compound) {
        ListTag ejectionData = compound.m_128437_("EmergencyEjectionData", 10);
        for (int i = 0; i < ejectionData.size(); ++i) {
            try {
                EjectionData e = EjectionData.loadData(ejectionData.m_128728_(i));
                if (e == null || e.m_7983_()) continue;
                this.emergencyEjectionData.add(e);
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading ejection data entry " + i, t);
            }
        }
        LightmansCurrency.LogDebug("Server loaded " + this.emergencyEjectionData.size() + " ejection data entries from file.");
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag ejectionData = new ListTag();
        this.emergencyEjectionData.forEach(data -> ejectionData.add((Object)data.save()));
        compound.m_128365_("EmergencyEjectionData", (Tag)ejectionData);
        return compound;
    }

    private static EjectionSaveData get() {
        ServerLevel level;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && (level = server.m_129880_(Level.f_46428_)) != null) {
            return (EjectionSaveData)level.m_8895_().m_164861_(EjectionSaveData::new, EjectionSaveData::new, "lightmanscurrency_ejection_data");
        }
        return null;
    }

    public static List<EjectionData> GetEjectionData(boolean isClient) {
        if (isClient) {
            return ClientEjectionData.GetEjectionData();
        }
        EjectionSaveData esd = EjectionSaveData.get();
        if (esd != null) {
            return new ArrayList<EjectionData>(esd.emergencyEjectionData);
        }
        return new ArrayList<EjectionData>();
    }

    public static List<EjectionData> GetValidEjectionData(boolean isClient, Player player) {
        List<EjectionData> ejectionData = EjectionSaveData.GetEjectionData(isClient);
        if (ejectionData != null) {
            return ejectionData.stream().filter(e -> e.canAccess(player)).collect(Collectors.toList());
        }
        return new ArrayList<EjectionData>();
    }

    @Deprecated
    public static void GiveOldEjectionData(EjectionData data) {
        EjectionSaveData esd = EjectionSaveData.get();
        if (esd != null && data != null && !data.m_7983_()) {
            esd.emergencyEjectionData.add(data);
            EjectionSaveData.MarkEjectionDataDirty();
        }
    }

    public static void HandleEjectionData(Level level, BlockPos pos, EjectionData data) {
        if (level.f_46443_) {
            return;
        }
        Objects.requireNonNull(data);
        if (((Boolean)Config.SERVER.safelyEjectIllegalBreaks.get()).booleanValue()) {
            EjectionSaveData esd = EjectionSaveData.get();
            if (esd != null) {
                esd.emergencyEjectionData.add(data);
                EjectionSaveData.MarkEjectionDataDirty();
            }
        } else {
            InventoryUtil.dumpContents(level, pos, data);
        }
    }

    public static void RemoveEjectionData(EjectionData data) {
        EjectionSaveData esd = EjectionSaveData.get();
        if (esd != null) {
            Objects.requireNonNull(data);
            if (esd.emergencyEjectionData.contains(data)) {
                esd.emergencyEjectionData.remove(data);
                EjectionSaveData.MarkEjectionDataDirty();
            }
        }
    }

    public static void MarkEjectionDataDirty() {
        EjectionSaveData esd = EjectionSaveData.get();
        if (esd != null) {
            esd.m_77762_();
            CompoundTag compound = new CompoundTag();
            ListTag ejectionList = new ListTag();
            esd.emergencyEjectionData.forEach(data -> ejectionList.add((Object)data.save()));
            compound.m_128365_("EmergencyEjectionData", (Tag)ejectionList);
            new SPacketSyncEjectionData(compound).sendToAll();
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EjectionSaveData esd = EjectionSaveData.get();
        CompoundTag compound = new CompoundTag();
        ListTag ejectionList = new ListTag();
        esd.emergencyEjectionData.forEach(data -> ejectionList.add((Object)data.save()));
        compound.m_128365_("EmergencyEjectionData", (Tag)ejectionList);
        new SPacketSyncEjectionData(compound).sendTo(event.getPlayer());
    }
}

