/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.enchantments;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.network.message.enchantments.SPacketMoneyMendingClink;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MoneyMendingEnchantment
extends Enchantment {
    public MoneyMendingEnchantment(Enchantment.Rarity rarity, EquipmentSlot ... slots) {
        super(rarity, EnchantmentCategory.BREAKABLE, slots);
    }

    public int m_6183_(int level) {
        return level * 25;
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + 50;
    }

    public boolean m_6591_() {
        return true;
    }

    public int m_6586_() {
        return 1;
    }

    protected boolean m_5975_(@Nonnull Enchantment otherEnchant) {
        return otherEnchant != Enchantments.f_44962_ && super.m_5975_(otherEnchant);
    }

    public static long getRepairCost() {
        return Config.SERVER.moneyMendingCoinCost.get().getValueNumber();
    }

    public static void runEntityTick(@Nonnull IWalletHandler walletHandler, LivingEntity entity) {
        ItemStack wallet = walletHandler.getWallet();
        if (WalletItem.isWallet(wallet)) {
            NonNullList<ItemStack> walletInventory = WalletItem.getWalletInventory(wallet);
            long currentWalletValue = MoneyUtil.getValue(walletInventory);
            long repairCost = MoneyMendingEnchantment.getRepairCost();
            if (repairCost > currentWalletValue) {
                return;
            }
            Map.Entry entry = EnchantmentHelper.m_44839_((Enchantment)((Enchantment)ModEnchantments.MONEY_MENDING.get()), (LivingEntity)entity, ItemStack::m_41768_);
            ItemStack item = null;
            if (entry == null) {
                if (LightmansCurrency.isCuriosValid(entity)) {
                    item = LCCurios.getMoneyMendingItem(entity);
                }
            } else {
                item = (ItemStack)entry.getValue();
            }
            if (entry != null) {
                int currentDamage = item.m_41773_();
                long repairAmount = Math.min((long)currentDamage, currentWalletValue / repairCost);
                item.m_41721_(currentDamage - (int)repairAmount);
                SimpleContainer newWalletInventory = new SimpleContainer(walletInventory.size());
                for (ItemStack coinStack : MoneyUtil.getCoinsOfValue(currentWalletValue -= repairAmount * repairCost)) {
                    AtomicReference<ItemStack> leftovers = new AtomicReference<ItemStack>(InventoryUtil.TryPutItemStack((Container)newWalletInventory, coinStack));
                    if (leftovers.get().m_41619_()) continue;
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)leftovers.get());
                        continue;
                    }
                    entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(entityInventory -> leftovers.set(ItemHandlerHelper.insertItemStacked((IItemHandler)entityInventory, (ItemStack)((ItemStack)leftovers.get()), (boolean)false)));
                    if (leftovers.get().m_41619_()) continue;
                    InventoryUtil.dumpContents(entity.f_19853_, entity.m_142538_(), leftovers.get());
                }
                WalletItem.putWalletInventory(wallet, InventoryUtil.buildList((Container)newWalletInventory));
                walletHandler.setWallet(wallet);
                WalletMenuBase.OnWalletUpdated((Entity)entity);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    SPacketMoneyMendingClink.INSTANCE.sendTo(player);
                }
            }
        }
    }
}

