/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.entity.merchant.villager;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.entity.merchant.villager.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.npc.VillagerTrades;

public class CustomVillagerTradeData {
    private static final ResourceLocation WANDERING_TRADER_ID = new ResourceLocation("lightmanscurrency", "wandering_trader");
    private static final Map<ResourceLocation, Map<Integer, List<VillagerTrades.ItemListing>>> defaultValues = new HashMap<ResourceLocation, Map<Integer, List<VillagerTrades.ItemListing>>>();

    private static Map<Integer, List<VillagerTrades.ItemListing>> getEmptyMap() {
        HashMap<Integer, List<VillagerTrades.ItemListing>> map = new HashMap<Integer, List<VillagerTrades.ItemListing>>();
        for (int i = 1; i <= 5; ++i) {
            map.put(i, new ArrayList());
        }
        return map;
    }

    private static Map<Integer, List<VillagerTrades.ItemListing>> getDefaultVillagerData(@Nonnull ResourceLocation villager) {
        return defaultValues.getOrDefault(villager, CustomVillagerTradeData.getEmptyMap());
    }

    public static void registerDefaultWanderingTrades(@Nonnull List<VillagerTrades.ItemListing> genericValues, @Nonnull List<VillagerTrades.ItemListing> rareValues) {
        HashMap<Integer, List<VillagerTrades.ItemListing>> valueMap = new HashMap<Integer, List<VillagerTrades.ItemListing>>();
        valueMap.put(1, genericValues);
        valueMap.put(2, rareValues);
        CustomVillagerTradeData.registerDefaultFile(WANDERING_TRADER_ID, valueMap);
    }

    public static void registerDefaultFile(@Nonnull ResourceLocation villager, @Nonnull Map<Integer, List<VillagerTrades.ItemListing>> value) {
        if (defaultValues.containsKey(villager)) {
            LightmansCurrency.LogWarning("Attempted to register default villager data of type '" + villager + "' twice!");
        } else {
            for (int i = 1; i <= 5; ++i) {
                if (value.get(i) != null) continue;
                LightmansCurrency.LogError("Default value for '" + villager + "' does not have all five valid entries!");
            }
            defaultValues.put(villager, value);
        }
    }

    public static Pair<List<VillagerTrades.ItemListing>, List<VillagerTrades.ItemListing>> getWanderingTraderData() {
        Map<Integer, List<VillagerTrades.ItemListing>> value = CustomVillagerTradeData.getVillagerData(WANDERING_TRADER_ID);
        return Pair.of((Object)value.getOrDefault(1, new ArrayList()), (Object)value.getOrDefault(2, new ArrayList()));
    }

    @Nonnull
    public static Map<Integer, List<VillagerTrades.ItemListing>> getVillagerData(@Nonnull ResourceLocation villager) {
        File file = CustomVillagerTradeData.getVillagerDataFile(villager);
        if (file.exists()) {
            try {
                String text = Files.readString(file.toPath());
                JsonObject json = GsonHelper.m_13864_((String)text);
                return ItemListingSerializer.deserialize(json);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading villager data file '" + file.getName() + "'!", t);
            }
        } else {
            try {
                File dir = file.getParentFile();
                dir.mkdirs();
                Map<Integer, List<VillagerTrades.ItemListing>> defaultValues = CustomVillagerTradeData.getDefaultVillagerData(villager);
                FileUtil.writeStringToFile(file, FileUtil.GSON.toJson((JsonElement)ItemListingSerializer.serialize(defaultValues, villager.equals((Object)WANDERING_TRADER_ID) ? 2 : 5)));
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error creating default villager data file '" + file.getName() + "'!", t);
            }
        }
        return CustomVillagerTradeData.getDefaultVillagerData(villager);
    }

    @Nonnull
    public static File getVillagerDataFile(@Nonnull ResourceLocation villager) {
        String filePath = "config/" + villager.m_135827_() + "/custom_" + villager.m_135815_() + "_trades.json";
        return new File(filePath);
    }
}

