/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.entity.merchant.villager.listings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.entity.merchant.villager.ItemListingSerializer;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class RandomTrade
implements VillagerTrades.ItemListing {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "random_selection");
    public static final Serializer SERIALIZER = new Serializer();
    protected final ItemStack price1;
    protected final ItemStack price2;
    protected final List<ItemStack> sellItemOptions;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;

    public static RandomTrade build(ItemStack price, List<? extends ItemLike> sellItemOptions, int maxTrades, int xpValue, float priceMult) {
        return RandomTrade.build(price, ItemStack.f_41583_, sellItemOptions, maxTrades, xpValue, priceMult);
    }

    public static RandomTrade build(ItemStack price1, ItemStack price2, List<? extends ItemLike> sellItemOptions, int maxTrades, int xpValue, float priceMult) {
        return new RandomTrade(price1, price2, RandomTrade.convertItemList(sellItemOptions), maxTrades, xpValue, priceMult);
    }

    public RandomTrade(ItemStack price, ItemLike[] sellItemOptions, int maxTrades, int xpValue, float priceMult) {
        this(price, ItemStack.f_41583_, sellItemOptions, maxTrades, xpValue, priceMult);
    }

    public RandomTrade(ItemStack price1, ItemStack price2, ItemLike[] sellItemOptions, int maxTrades, int xpValue, float priceMult) {
        this(price1, price2, RandomTrade.convertItemArray(sellItemOptions), maxTrades, xpValue, priceMult);
    }

    public RandomTrade(ItemStack price1, ItemStack price2, List<ItemStack> sellItemOptions, int maxTrades, int xpValue, float priceMult) {
        this.price1 = price1;
        this.price2 = price2;
        this.sellItemOptions = sellItemOptions;
        this.maxTrades = maxTrades;
        this.xp = xpValue;
        this.priceMult = priceMult;
    }

    private static List<ItemStack> convertItemArray(ItemLike[] array) {
        ArrayList<ItemStack> options = new ArrayList<ItemStack>();
        for (ItemLike item : array) {
            ItemStack stack = new ItemStack(item);
            if (stack.m_41619_()) continue;
            options.add(stack);
        }
        return options;
    }

    private static List<ItemStack> convertItemList(Iterable<? extends ItemLike> array) {
        ArrayList<ItemStack> options = new ArrayList<ItemStack>();
        for (ItemLike itemLike : array) {
            ItemStack stack = new ItemStack(itemLike);
            if (stack.m_41619_()) continue;
            options.add(stack);
        }
        return options;
    }

    public MerchantOffer m_5670_(@NotNull Entity trader, Random rand) {
        int index = rand.nextInt(this.sellItemOptions.size());
        ItemStack sellItem = this.sellItemOptions.get(index).m_41777_();
        return new MerchantOffer(this.price1, this.price2, sellItem, this.maxTrades, this.xp, this.priceMult);
    }

    private static class Serializer
    implements ItemListingSerializer.IItemListingSerializer,
    ItemListingSerializer.IItemListingDeserializer {
        private Serializer() {
        }

        @Override
        public ResourceLocation getType() {
            return TYPE;
        }

        @Override
        public JsonObject serializeInternal(JsonObject json, VillagerTrades.ItemListing trade) {
            if (trade instanceof RandomTrade) {
                RandomTrade t = (RandomTrade)trade;
                json.add("Price", (JsonElement)FileUtil.convertItemStack(t.price1));
                if (!t.price2.m_41619_()) {
                    json.add("Price2", (JsonElement)FileUtil.convertItemStack(t.price2));
                }
                JsonArray sellItems = new JsonArray();
                for (ItemStack item : t.sellItemOptions) {
                    sellItems.add((JsonElement)FileUtil.convertItemStack(item));
                }
                json.add("Sell", (JsonElement)sellItems);
                json.addProperty("MaxTrades", (Number)t.maxTrades);
                json.addProperty("XP", (Number)t.xp);
                json.addProperty("PriceMult", (Number)Float.valueOf(t.priceMult));
                return json;
            }
            return null;
        }

        @Override
        public VillagerTrades.ItemListing deserialize(JsonObject json) throws Exception {
            ItemStack price1 = FileUtil.parseItemStack(json.get("Price").getAsJsonObject());
            ItemStack price2 = json.has("Price2") ? FileUtil.parseItemStack(json.get("Price2").getAsJsonObject()) : ItemStack.f_41583_;
            ArrayList<ItemStack> sellItems = new ArrayList<ItemStack>();
            JsonArray sellItemsArray = json.getAsJsonArray("Sell");
            for (int i = 0; i < sellItemsArray.size(); ++i) {
                sellItems.add(FileUtil.parseItemStack(sellItemsArray.get(i).getAsJsonObject()));
            }
            int maxTrades = json.get("MaxTrades").getAsInt();
            int xp = json.get("XP").getAsInt();
            float priceMult = json.get("PriceMult").getAsFloat();
            return new RandomTrade(price1, price2, sellItems, maxTrades, xp, priceMult);
        }
    }
}

