/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.events;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.loot.tiers.ChestPoolLevel;
import io.github.lightman314.lightmanscurrency.common.loot.tiers.EntityPoolLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public abstract class DroplistConfigGenerator {
    private static final List<Consumer<Entity>> entityListeners = new ArrayList<Consumer<Entity>>();
    private static final List<Consumer<Chest>> chestListeners = new ArrayList<Consumer<Chest>>();
    private String defaultNamespace = "minecraft";
    private final List<ResourceLocation> entries = new ArrayList<ResourceLocation>();

    public static void registerEntityListener(@Nonnull Consumer<Entity> listener) {
        if (!entityListeners.contains(listener)) {
            entityListeners.add(listener);
        }
    }

    public static void registerChestListener(@Nonnull Consumer<Chest> listener) {
        if (!chestListeners.contains(listener)) {
            chestListeners.add(listener);
        }
    }

    public static List<String> CollectDefaultEntityDrops(EntityPoolLevel level) {
        Entity generator = new Entity(level);
        for (Consumer<Entity> listener : entityListeners) {
            try {
                listener.accept(generator);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error collecting default entity drops.", t);
            }
        }
        return DroplistConfigGenerator.debugEntries(generator.collectEntries(), "Collected Default Entity drops of type '" + level.toString() + "'!\n_VALUE_");
    }

    public static List<String> CollectDefaultChestDrops(ChestPoolLevel level) {
        Chest generator = new Chest(level);
        for (Consumer<Chest> listener : chestListeners) {
            try {
                listener.accept(generator);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error collecting default chest drops.", t);
            }
        }
        return DroplistConfigGenerator.debugEntries(generator.collectEntries(), "Collected Default Chest drops of type '" + level.toString() + "'!\n_VALUE_");
    }

    private static List<String> debugEntries(List<String> results, String message) {
        StringBuilder builder = new StringBuilder("[");
        for (String result : results) {
            if (results.indexOf(result) > 0) {
                builder.append(",");
            }
            builder.append('\"').append(result).append('\"');
        }
        builder.append(']');
        LightmansCurrency.LogDebug(message.replace("_VALUE_", builder.toString()));
        return results;
    }

    public final void resetDefaultNamespace() {
        this.defaultNamespace = "minecraft";
    }

    public final void setDefaultNamespace(@Nonnull String namespace) {
        this.defaultNamespace = namespace;
    }

    public final String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public final ImmutableList<ResourceLocation> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    protected final List<String> collectEntries() {
        return this.entries.stream().map(ResourceLocation::toString).toList();
    }

    protected DroplistConfigGenerator() {
    }

    protected abstract ResourceLocation createEntry(String var1, String var2);

    public final void addVanillaEntry(String entry) throws ResourceLocationException {
        this.addEntry("minecraft", entry);
    }

    public final void addEntry(String modid, String entry) throws ResourceLocationException {
        this.forceAddEntry(this.createEntry(modid, entry));
    }

    public final void addEntry(String entry) throws ResourceLocationException {
        this.addEntry(this.defaultNamespace, entry);
    }

    public final void forceAddEntry(ResourceLocation entry) {
        if (!this.entries.contains(entry)) {
            this.entries.add(entry);
        }
    }

    public final void removeEntry(ResourceLocation entry) {
        this.entries.remove(entry);
    }

    public static class Entity
    extends DroplistConfigGenerator {
        private final EntityPoolLevel level;

        public final EntityPoolLevel getTier() {
            return this.level;
        }

        protected Entity(EntityPoolLevel level) {
            this.level = level;
        }

        @Override
        protected ResourceLocation createEntry(String modid, String entry) {
            return new ResourceLocation(modid, entry);
        }
    }

    public static class Chest
    extends DroplistConfigGenerator {
        private final ChestPoolLevel level;

        public final ChestPoolLevel getTier() {
            return this.level;
        }

        protected Chest(ChestPoolLevel level) {
            this.level = level;
        }

        @Override
        protected ResourceLocation createEntry(String modid, String entry) {
            return new ResourceLocation(modid, "chests/" + entry);
        }
    }
}

