/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.events;

import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class TradeEvent
extends Event {
    private final PlayerReference player;
    private final TradeData trade;
    private final TraderData trader;

    public final PlayerReference getPlayerReference() {
        return this.player;
    }

    @Deprecated
    public final Player getPlayer() {
        return this.player.getPlayer();
    }

    public final TradeData getTrade() {
        return this.trade;
    }

    public final int getTradeIndex() {
        return this.trader.indexOfTrade(this.trade);
    }

    public final TraderData getTrader() {
        return this.trader;
    }

    protected TradeEvent(PlayerReference player, TradeData trade, TraderData trader) {
        this.player = player;
        this.trade = trade;
        this.trader = trader;
    }

    public static class PostTradeEvent
    extends TradeEvent {
        private boolean isDirty = false;
        private final CoinValue pricePaid;
        private final CoinValue taxesPaid;

        public CoinValue getPricePaid() {
            return this.pricePaid;
        }

        public CoinValue getTaxesPaid() {
            return this.taxesPaid;
        }

        public PostTradeEvent(PlayerReference player, TradeData trade, TraderData trader, CoinValue pricePaid, CoinValue taxesPaid) {
            super(player, trade, trader);
            this.pricePaid = pricePaid;
            this.taxesPaid = taxesPaid;
        }

        public boolean isDirty() {
            return this.isDirty;
        }

        public void markDirty() {
            this.isDirty = true;
        }

        public void clean() {
            this.isDirty = false;
        }
    }

    public static class TradeCostEvent
    extends TradeEvent {
        private boolean forceFree = false;
        private int pricePercentage = 100;
        CoinValue currentCost;

        public boolean forcedFree() {
            return this.forceFree;
        }

        public void makeFree() {
            this.forceFree = true;
        }

        public void makeNotFree() {
            this.forceFree = false;
        }

        public int getPricePercentage() {
            return this.pricePercentage;
        }

        public void setPricePercentage(int pricePercentage) {
            this.pricePercentage = pricePercentage;
        }

        public void giveDiscount(int percentage) {
            this.pricePercentage -= percentage;
        }

        public void hikePrice(int percentage) {
            this.pricePercentage += percentage;
        }

        public CoinValue getBaseCost() {
            return this.currentCost;
        }

        public CoinValue getCostResult() {
            return this.forceFree ? CoinValue.FREE : this.currentCost.percentageOfValue(this.pricePercentage);
        }

        public TradeCostEvent(PlayerReference player, TradeData trade, TraderData trader) {
            super(player, trade, trader);
            this.currentCost = trade.getCost();
        }
    }

    @Cancelable
    public static class PreTradeEvent
    extends TradeEvent {
        private final List<AlertData> alerts = new ArrayList<AlertData>();

        public PreTradeEvent(PlayerReference player, TradeData trade, TraderData trader) {
            super(player, trade, trader);
        }

        public void addAlert(AlertData alert, boolean cancelTrade) {
            this.alerts.add(alert);
            if (cancelTrade) {
                this.setCanceled(true);
            }
        }

        public void addHelpful(MutableComponent message) {
            this.addAlert(AlertData.helpful(message), false);
        }

        public void addWarning(MutableComponent message) {
            this.addAlert(AlertData.warn(message), false);
        }

        public void addError(MutableComponent message) {
            this.addAlert(AlertData.error(message), false);
        }

        public void addDenial(MutableComponent message) {
            this.addAlert(AlertData.error(message), true);
        }

        public List<AlertData> getAlertInfo() {
            return this.alerts;
        }
    }
}

