/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinData;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CoinItem
extends Item {
    public CoinItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        CoinItem.addCoinTooltips(stack, tooltip);
    }

    public static void addCoinTooltips(ItemStack stack, List<Component> tooltip) {
        CoinData coinData = MoneyUtil.getData(stack.m_41720_());
        if (coinData != null) {
            if (!Config.serverSpec.isLoaded()) {
                return;
            }
            switch ((CoinItemTooltipType)((Object)Config.SERVER.coinTooltipType.get())) {
                case DEFAULT: {
                    Pair<Item, Integer> upwardConversion;
                    if (coinData.convertsDownwards()) {
                        tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.coinworth.down", coinData.getDownwardConversion().getSecond(), MoneyUtil.getPluralName((Item)coinData.getDownwardConversion().getFirst()).getString()).m_130940_(ChatFormatting.YELLOW));
                    }
                    if ((upwardConversion = MoneyUtil.getUpwardConversion(stack.m_41720_())) == null) break;
                    tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.coinworth.up", upwardConversion.getSecond(), ((Item)upwardConversion.getFirst()).m_7626_(new ItemStack((ItemLike)upwardConversion.getFirst())).getString()).m_130940_(ChatFormatting.YELLOW));
                    break;
                }
                case VALUE: {
                    double value = coinData.getDisplayValue();
                    tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.coinworth.value", Config.formatValueDisplay(value)).m_130940_(ChatFormatting.YELLOW));
                    if (stack.m_41613_() <= 1) break;
                    tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.coinworth.value.stack", Config.formatValueDisplay(value * (double)stack.m_41613_())).m_130940_(ChatFormatting.YELLOW));
                    break;
                }
            }
        }
    }

    public static enum CoinItemTooltipType {
        DEFAULT,
        VALUE,
        NONE;

    }
}

