/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CoinJarItem
extends BlockItem {
    public CoinJarItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        List<ItemStack> jarStorage = CoinJarItem.readJarData(stack);
        if (jarStorage.size() > 0) {
            if (Screen.m_96638_()) {
                for (ItemStack coin : jarStorage) {
                    if (coin.m_41613_() > 1) {
                        tooltip.add((Component)EasyText.translatable("tooptip.lightmanscurrency.coinjar.storedcoins.multiple", coin.m_41613_(), coin.m_41786_()));
                        continue;
                    }
                    tooltip.add((Component)EasyText.translatable("tooptip.lightmanscurrency.coinjar.storedcoins.single", coin.m_41786_()));
                }
            } else {
                tooltip.add((Component)EasyText.translatable("tooptip.lightmanscurrency.coinjar.holdshift", new Object[0]).m_130940_(ChatFormatting.YELLOW));
            }
        }
    }

    private static List<ItemStack> readJarData(ItemStack stack) {
        CompoundTag jarData;
        CompoundTag compound;
        ArrayList<ItemStack> storage = new ArrayList<ItemStack>();
        if (stack.m_41782_() && (compound = stack.m_41783_()).m_128425_("JarData", 10) && (jarData = compound.m_128469_("JarData")).m_128441_("Coins")) {
            ListTag storageList = jarData.m_128437_("Coins", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundTag thisItem = storageList.m_128728_(i);
                storage.add(ItemStack.m_41712_((CompoundTag)thisItem));
            }
        }
        return storage;
    }

    public static class Colored
    extends CoinJarItem
    implements DyeableLeatherItem {
        public Colored(Block block, Item.Properties properties) {
            super(block, properties);
        }

        public int m_41121_(ItemStack stack) {
            CompoundTag compoundtag = stack.m_41737_("display");
            return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 0xFFFFFF;
        }

        public void m_6787_(@Nonnull CreativeModeTab tab, @Nonnull NonNullList<ItemStack> tabItems) {
            if (this.m_41389_(tab)) {
                for (Color c : Color.values()) {
                    ItemStack stack = new ItemStack((ItemLike)this);
                    this.m_41115_(stack, c.hexColor);
                    tabItems.add((Object)stack);
                }
            }
        }
    }
}

