/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.tickets.TicketSaveData;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TicketItem
extends Item {
    public static final long CREATIVE_TICKET_ID = -1L;
    public static final int CREATIVE_TICKET_COLOR = 0xFFFF00;

    public TicketItem(Item.Properties properties) {
        super(properties);
    }

    public void m_6787_(@Nonnull CreativeModeTab tab, @Nonnull NonNullList<ItemStack> itemList) {
        if (this.m_41389_(tab)) {
            itemList.add((Object)TicketItem.CreateTicketInternal(this, -1L, 0xFFFF00, 1));
        }
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        long ticketID;
        if (TicketItem.isPass(stack)) {
            tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.ticket.pass", new Object[0]));
        }
        if ((ticketID = TicketItem.GetTicketID(stack)) >= -1L) {
            tooltip.add((Component)EasyText.translatable("tooltip.lightmanscurrency.ticket.id", ticketID));
        }
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        TicketItem.GetTicketID(stack);
    }

    public static boolean isTicket(ItemStack ticket) {
        if (ticket.m_41619_() || !ticket.m_41782_()) {
            return false;
        }
        return ticket.m_41720_() == ModItems.TICKET.get();
    }

    public static boolean isPass(ItemStack ticket) {
        if (ticket.m_41619_() || !ticket.m_41782_()) {
            return false;
        }
        return ticket.m_41720_() == ModItems.TICKET_PASS.get();
    }

    public static boolean isTicketOrPass(ItemStack ticket) {
        if (ticket.m_41619_() || !ticket.m_41782_()) {
            return false;
        }
        return ticket.m_41720_() == ModItems.TICKET.get() || ticket.m_41720_() == ModItems.TICKET_PASS.get();
    }

    public static boolean isMasterTicket(ItemStack ticket) {
        if (ticket.m_41619_() || !ticket.m_41782_()) {
            return false;
        }
        return ticket.m_41720_() == ModItems.TICKET_MASTER.get();
    }

    public static long GetTicketID(ItemStack ticket) {
        if (ticket.m_41619_() || !(ticket.m_41720_() instanceof TicketItem) || !ticket.m_41782_()) {
            return Long.MIN_VALUE;
        }
        CompoundTag ticketTag = ticket.m_41783_();
        if (ticketTag.m_128425_("TicketID", 4)) {
            return ticketTag.m_128454_("TicketID");
        }
        if (ticketTag.m_128441_("TicketID")) {
            UUID oldID = ticketTag.m_128342_("TicketID");
            long newID = TicketSaveData.getConvertedID(oldID);
            ticketTag.m_128356_("TicketID", newID);
            ticketTag.m_128405_("TicketColor", Color.getFromIndex((long)newID).hexColor);
            return newID;
        }
        return Long.MIN_VALUE;
    }

    public static int GetTicketColor(ItemStack ticket) {
        if (ticket.m_41619_() || !(ticket.m_41720_() instanceof TicketItem) || !ticket.m_41782_()) {
            return 0xFFFFFF;
        }
        CompoundTag ticketTag = ticket.m_41783_();
        if (!ticketTag.m_128441_("TicketColor")) {
            return 0xFFFFFF;
        }
        return ticketTag.m_128451_("TicketColor");
    }

    public static int GetDefaultTicketColor(long ticketID) {
        if (ticketID == -1L) {
            return Color.YELLOW.hexColor;
        }
        return Color.getFromIndex((long)ticketID).hexColor;
    }

    public static ItemStack CreateMasterTicket(long ticketID) {
        return TicketItem.CreateMasterTicket(ticketID, Color.getFromIndex((long)ticketID).hexColor);
    }

    public static ItemStack CreateMasterTicket(long ticketID, int color) {
        return TicketItem.CreateTicketInternal((Item)ModItems.TICKET_MASTER.get(), ticketID, color, 1);
    }

    public static ItemStack CreatePass(long ticketID, int color) {
        return TicketItem.CreatePass(ticketID, color, 1);
    }

    public static ItemStack CreatePass(long ticketID, int color, int count) {
        return TicketItem.CreateTicketInternal((Item)ModItems.TICKET_PASS.get(), ticketID, color, count);
    }

    public static ItemStack CreateTicket(ItemStack master) {
        if (master.m_41720_() == ModItems.TICKET_MASTER.get()) {
            return TicketItem.CreateTicket(TicketItem.GetTicketID(master), TicketItem.GetTicketColor(master));
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack CreateTicket(long ticketID, int color) {
        return TicketItem.CreateTicket(ticketID, color, 1);
    }

    public static ItemStack CreateTicket(long ticketID, int color, int count) {
        return TicketItem.CreateTicketInternal((Item)ModItems.TICKET.get(), ticketID, color, count);
    }

    private static ItemStack CreateTicketInternal(Item item, long ticketID, int color, int count) {
        ItemStack ticket = new ItemStack((ItemLike)item, count);
        CompoundTag tag = ticket.m_41784_();
        tag.m_128356_("TicketID", ticketID);
        tag.m_128405_("TicketColor", color);
        return ticket;
    }

    public static void SetTicketColor(ItemStack ticket, Color color) {
        TicketItem.SetTicketColor(ticket, color.hexColor);
    }

    public static void SetTicketColor(ItemStack ticket, int color) {
        CompoundTag tag = ticket.m_41784_();
        tag.m_128405_("TicketColor", color);
    }

    public static MutableComponent getTicketMaterialsList() {
        MutableComponent list = EasyText.empty();
        try {
            for (Item item : ForgeRegistries.ITEMS.tags().getTag(LCTags.Items.TICKET_MATERIAL).stream().toList()) {
                list.m_7220_((Component)EasyText.literal("\n")).m_7220_(new ItemStack((ItemLike)item).m_41786_());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return list;
    }
}

