/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.NonNullSupplier;

public class TooltipItem
extends Item {
    public static final Style DEFAULT_STYLE = Style.f_131099_.m_131140_(ChatFormatting.GRAY);
    private final NonNullSupplier<List<Component>> tooltips;

    public TooltipItem(Item.Properties properties, NonNullSupplier<List<Component>> tooltips) {
        super(properties);
        this.tooltips = tooltips;
    }

    public static List<Component> getTooltipLines(String tooltipTranslation) {
        return TooltipItem.getTooltipLines(tooltipTranslation, DEFAULT_STYLE);
    }

    public static List<Component> getTooltipLines(String tooltipTranslation, @Nullable Style format) {
        ArrayList<Component> result = new ArrayList<Component>();
        int i = 0;
        TranslatableComponent nextLine;
        while ((nextLine = TooltipItem.getTooltipLine(tooltipTranslation, ++i)) != null) {
            if (format != null) {
                nextLine.m_130948_(format);
            }
            result.add((Component)nextLine);
        }
        return result;
    }

    private static TranslatableComponent getTooltipLine(String tooltipTranslation, int page) {
        String tt = (String)(tooltipTranslation.endsWith(".") ? tooltipTranslation : tooltipTranslation + ".") + page;
        TranslatableComponent result = new TranslatableComponent(tt);
        if (result.getString().contentEquals(tt)) {
            return null;
        }
        return result;
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, this.tooltips);
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    public static void addTooltip(List<Component> tooltip, NonNullSupplier<List<Component>> tooltipSource) {
        List addableTooltips = (List)tooltipSource.get();
        if (addableTooltips.size() == 0) {
            return;
        }
        if (Screen.m_96638_()) {
            tooltip.addAll((Collection)tooltipSource.get());
        } else {
            tooltip.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.tooltip").m_130948_(DEFAULT_STYLE));
        }
    }

    public static void addTooltipAlways(List<Component> tooltip, NonNullSupplier<List<Component>> tooltipSource) {
        tooltip.addAll((Collection)tooltipSource.get());
    }

    public static NonNullSupplier<List<Component>> combine(NonNullSupplier<List<Component>> ... tooltipSources) {
        return () -> {
            ArrayList result = new ArrayList();
            for (NonNullSupplier source : tooltipSources) {
                result.addAll((Collection)source.get());
            }
            return result;
        };
    }
}

