/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.bank.interfaces.IBankAccountAdvancedMenu;
import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.bank.reference.types.PlayerBankReference;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.money.ATMUtil;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ATMMenu
extends LazyMessageMenu
implements IBankAccountAdvancedMenu {
    private final Player player;
    private final Container coinInput = new SimpleContainer(9);
    private MutableComponent transferMessage = null;

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Container getCoinInput() {
        return this.coinInput;
    }

    public ATMMenu(int windowId, Inventory inventory, MenuValidator validator) {
        super((MenuType)ModMenus.ATM.get(), windowId, inventory, validator);
        int x;
        this.player = inventory.f_35978_;
        for (x = 0; x < this.coinInput.m_6643_(); ++x) {
            this.m_38897_(new CoinSlot(this.coinInput, x, 8 + x * 18, 129, false));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, 8 + x2 * 18, 161 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 219));
        }
    }

    @Override
    protected void onValidationTick(@Nonnull Player player) {
        this.getBankAccountReference();
    }

    public void m_6877_(@Nonnull Player player) {
        BankReference account;
        super.m_6877_(player);
        this.m_150411_(player, this.coinInput);
        if (!this.isClient() && !(account = this.getBankAccountReference()).canPersist(player)) {
            BankSaveData.SetSelectedBankAccount(this.player, PlayerBankReference.of(this.player));
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < this.coinInput.m_6643_() ? !this.m_38903_(slotStack, this.coinInput.m_6643_(), this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.coinInput.m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public void SendCoinExchangeMessage(String command) {
        this.SendMessageToServer(LazyPacketData.builder().setString("ExchangeCoinCommand", command));
    }

    public void ExchangeCoins(String command) {
        ATMUtil.ExecuteATMExchangeCommand(this.coinInput, command);
    }

    public MutableComponent SetPlayerAccount(String playerName) {
        if (LCAdminMode.isAdminPlayer(this.player)) {
            PlayerReference accountPlayer = PlayerReference.of(false, playerName);
            if (accountPlayer != null) {
                BankSaveData.SetSelectedBankAccount(this.player, PlayerBankReference.of(accountPlayer));
                return EasyText.translatable("gui.bank.select.player.success", accountPlayer.getName(false));
            }
            return EasyText.translatable("gui.bank.transfer.error.null.to", new Object[0]);
        }
        return EasyText.literal("ERROR");
    }

    public boolean hasTransferMessage() {
        return this.transferMessage != null;
    }

    public MutableComponent getTransferMessage() {
        return this.transferMessage;
    }

    @Override
    public void setTransferMessage(MutableComponent message) {
        this.transferMessage = message;
    }

    public void clearMessage() {
        this.transferMessage = null;
    }

    public void SetNotificationValueAndUpdate(CoinValue newValue) {
        BankAccount ba = this.getBankAccount();
        if (ba != null) {
            ba.setNotificationValue(newValue);
        }
        this.SendMessageToServer(LazyPacketData.builder().setCoinValue("NotificationValueChange", newValue));
    }

    @Override
    public void HandleMessage(LazyPacketData message) {
        BankAccount ba;
        if (message.contains("ExchangeCoinCommand")) {
            this.ExchangeCoins(message.getString("ExchangeCoinCommand"));
        }
        if (message.contains("NotificationValueChange") && (ba = this.getBankAccount()) != null) {
            ba.setNotificationValue(message.getCoinValue("NotificationValueChange"));
        }
    }
}

