/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.TicketMachineBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.LazyMessageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.slots.OutputSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketMaterialSlot;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketModifierSlot;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.common.tickets.TicketSaveData;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TicketMachineMenu
extends LazyMessageMenu {
    private final Container output = new SimpleContainer(1);
    private final TicketMachineBlockEntity blockEntity;

    public TicketMachineMenu(int windowId, Inventory inventory, TicketMachineBlockEntity blockEntity) {
        super((MenuType)ModMenus.TICKET_MACHINE.get(), windowId, inventory);
        this.blockEntity = blockEntity;
        this.addValidator(BlockEntityValidator.of(this.blockEntity));
        this.m_38897_(new TicketModifierSlot(this.blockEntity.getStorage(), 0, 20, 21));
        this.m_38897_(new TicketMaterialSlot(this.blockEntity.getStorage(), 1, 56, 21));
        this.m_38897_(new OutputSlot(this.output, 0, 116, 21));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 56 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 8 + x * 18, 114));
        }
    }

    public void m_6877_(@NotNull Player playerIn) {
        super.m_6877_(playerIn);
        this.m_150411_(playerIn, this.output);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            int totalSize = this.blockEntity.getStorage().m_6643_() + this.output.m_6643_();
            if (index < totalSize ? !this.m_38903_(slotStack, totalSize, this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.blockEntity.getStorage().m_6643_(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public boolean validInputs() {
        return !this.blockEntity.getStorage().m_8020_(1).m_41619_();
    }

    public boolean roomForOutput(boolean craftPass) {
        ItemStack outputStack = this.output.m_8020_(0);
        if (outputStack.m_41619_()) {
            return true;
        }
        if (this.hasMasterTicket() && (!craftPass && outputStack.m_41720_() == ModItems.TICKET.get() || craftPass && outputStack.m_41720_() == ModItems.TICKET_PASS.get())) {
            long outputTicketID;
            long ticketID = this.getTicketID();
            return ticketID == (outputTicketID = TicketItem.GetTicketID(outputStack));
        }
        return false;
    }

    public boolean hasMasterTicket() {
        ItemStack masterTicket = this.blockEntity.getStorage().m_8020_(0);
        return TicketItem.isMasterTicket(masterTicket);
    }

    public void craftTickets(boolean fullStack, boolean craftPass) {
        if (!this.validInputs()) {
            LightmansCurrency.LogDebug("Inputs for the Ticket Machine are not valid. Cannot craft tickets.");
            return;
        }
        if (!this.roomForOutput(craftPass)) {
            LightmansCurrency.LogDebug("No room for Ticket Machine outputs. Cannot craft tickets.");
            return;
        }
        if (this.hasMasterTicket()) {
            ItemStack outputStack;
            int count = 1;
            if (fullStack) {
                count = this.blockEntity.getStorage().m_8020_(1).m_41613_();
            }
            if ((outputStack = this.output.m_8020_(0)).m_41619_()) {
                ItemStack newTicket = craftPass ? TicketItem.CreatePass(this.getTicketID(), this.getTicketColor(), count) : TicketItem.CreateTicket(this.getTicketID(), this.getTicketColor(), count);
                this.output.m_6836_(0, newTicket);
            } else {
                count = Math.min(count, outputStack.m_41741_() - outputStack.m_41613_());
                outputStack.m_41764_(outputStack.m_41613_() + count);
            }
            this.blockEntity.getStorage().m_7407_(1, count);
        } else {
            Color dye = this.getDyeColor();
            ItemStack newTicket = TicketItem.CreateMasterTicket(TicketSaveData.createNextID());
            if (dye != null) {
                TicketItem.SetTicketColor(newTicket, dye);
                this.blockEntity.getStorage().m_7407_(0, 1);
            }
            this.output.m_6836_(0, newTicket);
            this.blockEntity.getStorage().m_7407_(1, 1);
        }
    }

    public long getTicketID() {
        ItemStack masterTicket = this.blockEntity.getStorage().m_8020_(0);
        if (TicketItem.isMasterTicket(masterTicket)) {
            return TicketItem.GetTicketID(masterTicket);
        }
        return Long.MIN_VALUE;
    }

    public int getTicketColor() {
        ItemStack stack = this.blockEntity.getStorage().m_8020_(0);
        if (TicketItem.isMasterTicket(stack)) {
            return TicketItem.GetTicketColor(stack);
        }
        return 0xFFFFFF;
    }

    @Nullable
    public Color getDyeColor() {
        ItemStack stack = this.blockEntity.getStorage().m_8020_(0);
        return TicketModifierSlot.getColorFromDye(stack);
    }

    public void SendCraftTicketsMessage(boolean fullStack, boolean craftPass) {
        this.SendMessageToServer(LazyPacketData.builder().setBoolean("CraftTickets", fullStack).setBoolean("CraftPass", craftPass));
    }

    @Override
    public void HandleMessage(LazyPacketData message) {
        if (message.contains("CraftTickets")) {
            this.craftTickets(message.getBoolean("CraftTickets"), message.getBoolean("CraftPass"));
        }
    }
}

