/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.TraderInterfaceTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base.InfoTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base.OwnershipTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base.TradeSelectTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderinterface.base.TraderSelectTab;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.BlockEntityValidator;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.network.message.interfacebe.CPacketInterfaceInteraction;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullFunction;

public class TraderInterfaceMenu
extends EasyMenu {
    private final TraderInterfaceBlockEntity blockEntity;
    public static final int SLOT_OFFSET = 15;
    private boolean canEditTabs;
    Map<Integer, TraderInterfaceTab> availableTabs = new HashMap<Integer, TraderInterfaceTab>();
    int currentTab = 0;

    public final TraderInterfaceBlockEntity getBE() {
        return this.blockEntity;
    }

    public Map<Integer, TraderInterfaceTab> getAllTabs() {
        return this.availableTabs;
    }

    public void setTab(int key, TraderInterfaceTab tab) {
        if (this.canEditTabs && tab != null) {
            this.availableTabs.put(key, tab);
        } else if (tab == null) {
            LightmansCurrency.LogError("Attempted to set a null storage tab in slot " + key);
        } else {
            LightmansCurrency.LogError("Attempted to define the tab in " + key + " but the tabs have been locked.");
        }
    }

    public int getCurrentTabIndex() {
        return this.currentTab;
    }

    public TraderInterfaceTab getCurrentTab() {
        return this.availableTabs.get(this.currentTab);
    }

    @Override
    public boolean isClient() {
        return this.player.f_19853_.f_46443_;
    }

    public TraderInterfaceMenu(int windowID, Inventory inventory, TraderInterfaceBlockEntity blockEntity) {
        super((MenuType)ModMenus.TRADER_INTERFACE.get(), windowID, inventory);
        this.blockEntity = blockEntity;
        this.addValidator(BlockEntityValidator.of(this.blockEntity));
        this.addValidator((NonNullFunction<Player, Boolean>)((NonNullFunction)this.blockEntity::canAccess));
        this.canEditTabs = true;
        this.setTab(0, new InfoTab(this));
        this.setTab(2, new TraderSelectTab(this));
        this.setTab(3, new TradeSelectTab(this));
        this.setTab(100, new OwnershipTab(this));
        if (this.blockEntity != null) {
            this.blockEntity.initMenuTabs(this);
        }
        this.canEditTabs = false;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)inventory, x + y * 9 + 9, 23 + x * 18, 154 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 23 + x * 18, 212));
        }
        this.availableTabs.forEach((key, tab) -> tab.addStorageMenuSlots(x$0 -> this.m_38897_((Slot)x$0)));
        try {
            this.getCurrentTab().onTabOpen();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.availableTabs.forEach((key, tab) -> tab.onMenuClose());
    }

    public TradeContext getTradeContext() {
        return this.blockEntity.getTradeContext();
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < 36 ? !this.getCurrentTab().quickMoveStack(slotStack) && !this.m_38903_(slotStack, 36, this.f_38839_.size(), false) : index < this.f_38839_.size() && !this.m_38903_(slotStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public void changeTab(int key) {
        if (this.currentTab == key) {
            return;
        }
        if (this.availableTabs.containsKey(key)) {
            if (this.availableTabs.get(key).canOpen(this.player)) {
                this.getCurrentTab().onTabClose();
                this.currentTab = key;
                this.getCurrentTab().onTabOpen();
            }
        } else {
            LightmansCurrency.LogWarning("Trader Storage Menu doesn't have a tab defined for " + key);
        }
    }

    public void changeMode(TraderInterfaceBlockEntity.ActiveMode newMode) {
        this.blockEntity.setMode(newMode);
        if (this.isClient()) {
            CompoundTag message = new CompoundTag();
            message.m_128405_("ModeChange", newMode.index);
            this.sendMessage(message);
        }
    }

    public void setOnlineMode(boolean newMode) {
        this.blockEntity.setOnlineMode(newMode);
        if (this.isClient()) {
            CompoundTag message = new CompoundTag();
            message.m_128379_("OnlineModeChange", newMode);
            this.sendMessage(message);
        }
    }

    public CompoundTag createTabChangeMessage(int newTab, @Nullable CompoundTag extraData) {
        CompoundTag message = extraData == null ? new CompoundTag() : extraData;
        message.m_128405_("ChangeTab", newTab);
        return message;
    }

    public void sendMessage(CompoundTag message) {
        if (this.isClient()) {
            new CPacketInterfaceInteraction(message).send();
        }
    }

    public void receiveMessage(CompoundTag message) {
        if (message.m_128425_("ChangeTab", 3)) {
            this.changeTab(message.m_128451_("ChangeTab"));
        }
        if (message.m_128441_("ModeChange")) {
            this.changeMode(TraderInterfaceBlockEntity.ActiveMode.fromIndex(message.m_128451_("ModeChange")));
        }
        if (message.m_128441_("OnlineModeChange")) {
            this.setOnlineMode(message.m_128471_("OnlineModeChange"));
        }
        try {
            this.getCurrentTab().receiveMessage(message);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

