/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.slots;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasyMultiBGSlot;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InteractionSlot
extends EasyMultiBGSlot {
    public final List<InteractionSlotData> slotData;

    public InteractionSlot(List<InteractionSlotData> slotData, int x, int y) {
        super((Container)new SimpleContainer(1), 0, x, y);
        this.slotData = slotData;
    }

    public boolean isType(String type) {
        for (InteractionSlotData slot : this.slotData) {
            if (!slot.type.contentEquals(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6659_() {
        return this.slotData.size() > 0;
    }

    public int m_6641_() {
        return 1;
    }

    @Override
    public boolean m_5857_(@NotNull ItemStack stack) {
        return InteractionSlotData.allowItemInSlot(this.slotData, stack);
    }

    @Override
    protected List<Pair<ResourceLocation, ResourceLocation>> getPossibleNoItemIcons() {
        ArrayList<Pair<ResourceLocation, ResourceLocation>> possibleBGs = new ArrayList<Pair<ResourceLocation, ResourceLocation>>();
        for (InteractionSlotData slot : this.slotData) {
            Pair<ResourceLocation, ResourceLocation> bg = slot.emptySlotBG();
            if (bg == null) continue;
            possibleBGs.add(bg);
        }
        return possibleBGs;
    }
}

