/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.traderstorage.paygate;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.paygate.PaygateTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaygateTradeEditTab
extends TraderStorageTab {
    private int tradeIndex = -1;

    public PaygateTradeEditTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Object createClientTab(Object screen) {
        return new PaygateTradeEditClientTab(screen, this);
    }

    @Override
    public boolean canOpen(Player player) {
        return this.menu.hasPermission("editTrades");
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public PaygateTradeData getTrade() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            if (this.tradeIndex >= paygate.getTradeCount() || this.tradeIndex < 0) {
                this.menu.changeTab(0);
                this.menu.SendMessage(this.menu.createTabChangeMessage(0));
                return null;
            }
            return paygate.getTrade(this.tradeIndex);
        }
        return null;
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void setTradeIndex(int tradeIndex) {
        this.tradeIndex = tradeIndex;
    }

    public void setPrice(CoinValue price) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setCost(price);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                this.menu.SendMessage(LazyPacketData.simpleCoinValue("NewPrice", price));
            }
        }
    }

    public void setTicket(ItemStack ticket) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setTicket(ticket);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                this.menu.SendMessage(LazyPacketData.builder().setBoolean("NewTicket", true).setCompound("Ticket", ticket.m_41739_(new CompoundTag())));
            }
        }
    }

    public void setDuration(int duration) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setDuration(duration);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                this.menu.SendMessage(LazyPacketData.simpleInt("NewDuration", duration));
            }
        }
    }

    public void setTicketStubHandling(boolean storeTicketStubs) {
        PaygateTradeData trade = this.getTrade();
        if (trade != null) {
            trade.setStoreTicketStubs(storeTicketStubs);
            this.menu.getTrader().markTradesDirty();
            if (this.menu.isClient()) {
                this.menu.SendMessage(LazyPacketData.simpleBoolean("StoreTicketStubs", storeTicketStubs));
            }
        }
    }

    @Override
    public void receiveMessage(LazyPacketData message) {
        if (message.contains("TradeIndex")) {
            this.tradeIndex = message.getInt("TradeIndex");
        } else if (message.contains("NewPrice")) {
            this.setPrice(message.getCoinValue("NewPrice"));
        } else if (message.contains("NewTicket")) {
            ItemStack ticket = ItemStack.f_41583_;
            if (message.contains("Ticket")) {
                ticket = ItemStack.m_41712_((CompoundTag)message.getNBT("Ticket"));
            }
            this.setTicket(ticket);
        } else if (message.contains("NewDuration")) {
            this.setDuration(message.getInt("NewDuration"));
        } else if (message.contains("StoreTicketStubs")) {
            this.setTicketStubHandling(message.getBoolean("StoreTicketStubs"));
        }
    }
}

