/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.validation;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidatorType;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class MenuValidator {
    public final MenuValidatorType type;

    protected MenuValidator(MenuValidatorType type) {
        this.type = type;
    }

    public final void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.type.type.toString());
        this.encodeAdditional(buffer);
    }

    protected abstract void encodeAdditional(@Nonnull FriendlyByteBuf var1);

    public final void save() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        tag.m_128359_("Type", this.type.type.toString());
    }

    protected abstract void saveAdditional(@Nonnull CompoundTag var1);

    public abstract boolean stillValid(@Nonnull Player var1);

    @Nonnull
    public static MenuValidator decode(@Nonnull FriendlyByteBuf buffer) {
        try {
            ResourceLocation type = new ResourceLocation(buffer.m_130277_());
            MenuValidatorType decoder = MenuValidatorType.getType(type);
            if (decoder != null) {
                return decoder.decode(buffer);
            }
            LightmansCurrency.LogError("Could not decode MenuValidator of type '" + type + "'!");
            return SimpleValidator.NULL;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error decoding MenuValidator!");
            return SimpleValidator.NULL;
        }
    }

    @Nonnull
    public static MenuValidator load(@Nonnull CompoundTag tag) {
        try {
            ResourceLocation type = new ResourceLocation(tag.m_128461_("Type"));
            MenuValidatorType decoder = MenuValidatorType.getType(type);
            if (decoder != null) {
                decoder.load(tag);
            }
            LightmansCurrency.LogError("Could not load MenuValidator of type '" + type + "'!");
            return SimpleValidator.NULL;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error loading MenuValidator!");
            return SimpleValidator.NULL;
        }
    }
}

