/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.events.GetDefaultMoneyDataEvent;
import io.github.lightman314.lightmanscurrency.common.money.CoinData;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.packet.CustomPacket;
import io.github.lightman314.lightmanscurrency.network.packet.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class MoneyData
extends ServerToClientPacket {
    public static final CustomPacket.Handler<MoneyData> PACKET_HANDLER = new PacketHandler();
    private final List<CoinData> coinList = new ArrayList<CoinData>();
    private List<CoinData> sortedCoinList = new ArrayList<CoinData>();

    public MoneyData(CoinDataCollector collector) {
        for (CoinData.Builder dataBuilder : collector.coinBuilderList) {
            this.addCoinItem(dataBuilder);
        }
        this.sortCoinList();
    }

    public static MoneyData fromJson(JsonObject json) throws Throwable {
        JsonArray array = json.get("CoinEntries").getAsJsonArray();
        CoinDataCollector collector = new CoinDataCollector();
        for (int i = 0; i < array.size(); ++i) {
            try {
                CoinData.Builder builder = CoinData.getBuilder(array.get(i).getAsJsonObject());
                collector.addCoinBuilder(builder);
                continue;
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error loading coin entry " + (i + 1), e);
            }
        }
        return new MoneyData(collector);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray dataList = new JsonArray();
        for (CoinData coinData : this.coinList) {
            try {
                JsonObject entry = coinData.toJson();
                dataList.add((JsonElement)entry);
            }
            catch (Throwable throwable) {}
        }
        json.add("CoinEntries", (JsonElement)dataList);
        return json;
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buffer) {
        JsonObject json = this.toJson();
        String jsonString = FileUtil.GSON.toJson((JsonElement)json);
        int stringSize = jsonString.length();
        buffer.writeInt(stringSize);
        buffer.m_130072_(jsonString, stringSize);
    }

    public static MoneyData generateDefault() {
        GetDefaultMoneyDataEvent e = new GetDefaultMoneyDataEvent(new CoinDataCollector());
        MinecraftForge.EVENT_BUS.post((Event)e);
        return new MoneyData(e.dataCollector);
    }

    private void addCoinItem(CoinData.Builder newCoinDataBuilder) {
        CoinData newCoinData = newCoinDataBuilder.build();
        for (CoinData coinData : this.coinList) {
            if (coinData.coinItem == newCoinData.coinItem) {
                LightmansCurrency.LogWarning("Attempted to add Duplicate Coin Item (" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)newCoinData.coinItem).toString() + ") to the coin list.");
                return;
            }
            if (coinData.worthOtherCoin != newCoinData.worthOtherCoin || newCoinData.isHidden || coinData.isHidden || newCoinData.worthOtherCoin == null || !coinData.chain.contentEquals(newCoinData.chain)) continue;
            LightmansCurrency.LogWarning("Attempted to add a new Coin Item '" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)newCoinData.coinItem) + "' with the same dependent (" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)coinData.worthOtherCoin) + ") as another coin (" + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)coinData.coinItem) + ") in the same chain '" + coinData.chain + "'.\nEntry will be flagged as hidden.");
            newCoinData = newCoinDataBuilder.setHidden().build();
        }
        LightmansCurrency.LogInfo("Registered " + ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)newCoinData.coinItem) + " as a coin.");
        this.coinList.add(newCoinData);
    }

    private void sortCoinList() {
        this.sortedCoinList = new ArrayList<CoinData>();
        ArrayList copyList = Lists.newArrayList(this.coinList);
        while (copyList.size() > 0) {
            int highestValueIndex = 0;
            long highestValue = ((CoinData)copyList.get(0)).getValue(this);
            for (int i = 1; i < copyList.size(); ++i) {
                if (((CoinData)copyList.get(i)).getValue(this) <= highestValue) continue;
                highestValueIndex = i;
                highestValue = ((CoinData)copyList.get(i)).getValue(this);
            }
            this.sortedCoinList.add((CoinData)copyList.get(highestValueIndex));
            copyList.remove(highestValueIndex);
        }
    }

    public MutableComponent getPluralName(Item coinItem) {
        CoinData data = this.getData(coinItem);
        if (data != null) {
            return data.getPlural();
        }
        return MoneyUtil.getDefaultPlural(coinItem);
    }

    public CoinData getData(Item coinItem) {
        for (CoinData data : this.coinList) {
            if (data.coinItem != coinItem) continue;
            return data;
        }
        return null;
    }

    public ImmutableList<CoinData> getSortedCoinList() {
        return ImmutableList.copyOf(this.sortedCoinList);
    }

    public ImmutableList<CoinData> getSortedCoinList(String chain) {
        ArrayList<CoinData> results = new ArrayList<CoinData>();
        for (CoinData data : this.sortedCoinList) {
            if (!data.chain.contentEquals(chain)) continue;
            results.add(data);
        }
        return ImmutableList.copyOf(results);
    }

    public static class CoinDataCollector {
        List<CoinData.Builder> coinBuilderList = new ArrayList<CoinData.Builder>();

        public void addCoinBuilder(CoinData.Builder coinBuilder) {
            this.coinBuilderList.add(coinBuilder);
        }
    }

    private static class PacketHandler
    extends CustomPacket.Handler<MoneyData> {
        private PacketHandler() {
        }

        @Override
        @Nonnull
        public MoneyData decode(@Nonnull FriendlyByteBuf buffer) {
            try {
                LightmansCurrency.LogInfo("Decoding money data packet:");
                int stringSize = buffer.readInt();
                String jsonString = buffer.m_130136_(stringSize);
                JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
                return MoneyData.fromJson(json);
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error decoding MoneyData.", t);
                return MoneyData.generateDefault();
            }
        }

        @Override
        protected void handle(@Nonnull MoneyData message, @Nullable ServerPlayer sender) {
            LightmansCurrency.LogInfo("Received money data packet from server. Synchronizing coin list.");
            MoneyUtil.receiveMoneyData(message);
        }
    }
}

