/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money.util;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.NumberUtil;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class CoinValueParser {
    private static final CommandExceptionType EXCEPTION_TYPE = new CommandExceptionType(){

        public int hashCode() {
            return super.hashCode();
        }
    };

    public static CoinValue ParseConfigString(String string, Supplier<CoinValue> defaultValue) {
        try {
            return CoinValueParser.parse(new StringReader(string));
        }
        catch (CommandSyntaxException exception) {
            LightmansCurrency.LogError("Error parsing Coin Value config input.", new Object[]{exception});
            return defaultValue.get();
        }
    }

    public static CoinValue parse(StringReader reader) throws CommandSyntaxException {
        CoinValue value = CoinValue.EMPTY;
        StringReader inputReader = new StringReader(CoinValueParser.readStringUntil(reader, ' '));
        while (inputReader.canRead()) {
            String s1 = CoinValueParser.readStringUntil(inputReader, '-', ',');
            if (NumberUtil.IsInteger(s1)) {
                int count = NumberUtil.GetIntegerValue(s1, 1);
                String s2 = CoinValueParser.readStringUntil(inputReader, ',');
                value = CoinValueParser.TryParseCoin(value, inputReader, s2, count);
                continue;
            }
            value = CoinValueParser.TryParseCoin(value, inputReader, s1, 1);
        }
        if (!value.hasAny()) {
            throw CoinValueParser.NoValueException(reader);
        }
        return value;
    }

    private static String readStringUntil(StringReader reader, char ... t) throws CommandSyntaxException {
        ArrayList<Character> terminators = new ArrayList<Character>();
        for (char c : t) {
            terminators.add(Character.valueOf(c));
        }
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        while (reader.canRead()) {
            char c = reader.read();
            if (escaped) {
                if (terminators.contains(Character.valueOf(c)) || c == '\\') {
                    result.append(c);
                    escaped = false;
                    continue;
                }
                reader.setCursor(reader.getCursor() - 1);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidEscape().createWithContext((ImmutableStringReader)reader, (Object)String.valueOf(c));
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (terminators.contains(Character.valueOf(c))) {
                return result.toString();
            }
            result.append(c);
        }
        return result.toString();
    }

    private static CoinValue TryParseCoin(CoinValue result, StringReader reader, String coinIDString, int count) throws CommandSyntaxException {
        if (ResourceLocation.m_135830_((String)coinIDString)) {
            ResourceLocation coinID = new ResourceLocation(coinIDString);
            Item coin = (Item)ForgeRegistries.ITEMS.getValue(coinID);
            if (!MoneyUtil.isVisibleCoin(coin)) {
                throw CoinValueParser.NotACoinException(coinIDString, reader);
            }
            return result.plusValue(coin, count);
        }
        throw CoinValueParser.NotACoinException(coinIDString, reader);
    }

    public static CommandSyntaxException NoValueException(StringReader reader) {
        return new CommandSyntaxException(EXCEPTION_TYPE, (Message)EasyText.translatable("command.argument.coinvalue.novalue", new Object[0]), reader.getString(), reader.getCursor());
    }

    public static CommandSyntaxException NotACoinException(String item, StringReader reader) {
        return new CommandSyntaxException(EXCEPTION_TYPE, (Message)EasyText.translatable("command.argument.coinvalue.notacoin", item), reader.getString(), reader.getCursor());
    }
}

