/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class Notification {
    private static final Map<String, Function<CompoundTag, Notification>> DESERIALIZERS = new HashMap<String, Function<CompoundTag, Notification>>();
    private long timeStamp = TimeUtil.getCurrentTime();
    private boolean seen = false;
    private int count = 1;

    public static void register(ResourceLocation type, Supplier<Notification> deserializer) {
        Notification.register(type, (CompoundTag c) -> {
            Notification n = (Notification)deserializer.get();
            n.load((CompoundTag)c);
            return n;
        });
    }

    public static void register(ResourceLocation type, Function<CompoundTag, Notification> deserializer) {
        String t = type.toString();
        if (DESERIALIZERS.containsKey(t)) {
            LightmansCurrency.LogError("Notification of type " + t + " is already registered.");
            return;
        }
        if (deserializer == null) {
            LightmansCurrency.LogError("Deserializer of notification type " + t + " is null. Unable to register.");
            return;
        }
        DESERIALIZERS.put(t, deserializer);
    }

    public static Notification deserialize(CompoundTag compound) {
        if (compound.m_128441_("Type") || compound.m_128441_("type")) {
            String type;
            String string = type = compound.m_128441_("Type") ? compound.m_128461_("Type") : compound.m_128461_("type");
            if (DESERIALIZERS.containsKey(type)) {
                return DESERIALIZERS.get(type).apply(compound);
            }
            LightmansCurrency.LogError("Cannot deserialize notification type " + type + " as no deserializer has been registered.");
            return null;
        }
        LightmansCurrency.LogError("Cannot deserialize notification as tag is missing the 'type' tag.");
        return null;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public final boolean hasTimeStamp() {
        return this.getTimeStamp() > 0L;
    }

    public boolean wasSeen() {
        return this.seen;
    }

    public void setSeen() {
        this.seen = true;
    }

    public int getCount() {
        return this.count;
    }

    protected Notification() {
    }

    protected abstract ResourceLocation getType();

    public abstract NotificationCategory getCategory();

    public abstract MutableComponent getMessage();

    public MutableComponent getGeneralMessage() {
        return EasyText.translatable("notifications.source.general.format", this.getCategory().getName(), this.getMessage());
    }

    public MutableComponent getChatMessage() {
        return EasyText.translatable("notifications.chat.format", EasyText.translatable("notifications.chat.format.title", this.getCategory().getName()).m_130940_(ChatFormatting.GOLD), this.getMessage());
    }

    public Component getTimeStampMessage() {
        return EasyText.translatable("notifications.timestamp", TimeUtil.formatTime(this.timeStamp));
    }

    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        if (this.seen) {
            compound.m_128379_("Seen", true);
        }
        compound.m_128405_("Count", this.count);
        compound.m_128359_("Type", this.getType().toString());
        if (this.timeStamp > 0L) {
            compound.m_128356_("TimeStamp", this.timeStamp);
        }
        this.saveAdditional(compound);
        return compound;
    }

    protected abstract void saveAdditional(CompoundTag var1);

    public final void load(CompoundTag compound) {
        if (compound.m_128441_("Seen")) {
            this.seen = true;
        }
        if (compound.m_128425_("Count", 3)) {
            this.count = compound.m_128451_("Count");
        }
        this.timeStamp = compound.m_128425_("TimeStamp", 4) ? compound.m_128454_("TimeStamp") : 0L;
        this.loadAdditional(compound);
    }

    protected abstract void loadAdditional(CompoundTag var1);

    public boolean onNewNotification(Notification other) {
        if (this.canMerge(other)) {
            ++this.count;
            this.seen = false;
            this.timeStamp = TimeUtil.getCurrentTime();
            return true;
        }
        return false;
    }

    protected abstract boolean canMerge(Notification var1);
}

