/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types;

import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class TextNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "text");
    private MutableComponent text = EasyText.literal("");
    private NotificationCategory category = NullCategory.INSTANCE;

    public TextNotification(MutableComponent text) {
        this(text, NullCategory.INSTANCE);
    }

    public TextNotification(MutableComponent text, NotificationCategory category) {
        this.text = text;
        this.category = category;
    }

    public TextNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.category;
    }

    @Override
    public MutableComponent getMessage() {
        return this.text;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128359_("Text", EasyText.Serializer.m_130703_((Component)this.text));
        compound.m_128365_("Category", (Tag)this.category.save());
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        if (compound.m_128425_("Text", 8)) {
            this.text = EasyText.Serializer.m_130701_((String)compound.m_128461_("Text"));
        }
        if (compound.m_128425_("Category", 10)) {
            this.category = NotificationCategory.deserialize(compound.m_128469_("Category"));
        }
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof TextNotification) {
            TextNotification otherText = (TextNotification)other;
            return otherText.text.getString().equals(this.text.getString());
        }
        return false;
    }
}

