/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.settings;

import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.NullCategory;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AddRemoveAllyNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "add_remove_ally");
    PlayerReference player;
    boolean isAdd;
    PlayerReference ally;

    public AddRemoveAllyNotification(PlayerReference player, boolean isAdd, PlayerReference ally) {
        this.player = player;
        this.isAdd = isAdd;
        this.ally = ally;
    }

    public AddRemoveAllyNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return NullCategory.INSTANCE;
    }

    @Override
    public MutableComponent getMessage() {
        return EasyText.translatable("log.settings.addremoveally", this.player.getName(true), EasyText.translatable(this.isAdd ? "log.settings.add" : "log.settings.remove", new Object[0]), this.ally.getName(true), EasyText.translatable(this.isAdd ? "log.settings.to" : "log.settings.from", new Object[0]));
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("Player", (Tag)this.player.save());
        compound.m_128379_("Add", this.isAdd);
        compound.m_128365_("Ally", (Tag)this.ally.save());
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.player = PlayerReference.load(compound.m_128469_("Player"));
        this.isAdd = compound.m_128471_("Add");
        this.ally = PlayerReference.load(compound.m_128469_("Ally"));
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof AddRemoveAllyNotification) {
            AddRemoveAllyNotification n = (AddRemoveAllyNotification)other;
            return n.player.is(this.player) && n.isAdd == this.isAdd && n.ally.is(this.ally);
        }
        return false;
    }
}

