/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.taxes;

import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.NonNullSupplier;

public class TaxesPaidNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "taxes_paid");
    private CoinValue amount = CoinValue.EMPTY;
    private NotificationCategory category = NotificationCategory.GENERAL;

    private TaxesPaidNotification(CoinValue amount, NotificationCategory category) {
        this.amount = amount;
        this.category = category;
    }

    public static NonNullSupplier<Notification> create(CoinValue amount, NotificationCategory category) {
        return () -> new TaxesPaidNotification(amount, category);
    }

    public TaxesPaidNotification(CompoundTag tag) {
        this.load(tag);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.category;
    }

    @Override
    public MutableComponent getMessage() {
        if (this.amount.hasAny()) {
            return EasyText.translatable("notifications.message.taxes.paid", this.amount.getComponent("ERROR"));
        }
        return EasyText.translatable("notifications.message.taxes.paid.null", new Object[0]);
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("Amount", (Tag)this.amount.save());
        compound.m_128365_("Category", (Tag)this.category.save());
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.amount = CoinValue.load(compound.m_128469_("Amount"));
        this.category = NotificationCategory.deserialize(compound.m_128469_("Category"));
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof TaxesPaidNotification) {
            TaxesPaidNotification tpn = (TaxesPaidNotification)other;
            return tpn.amount.equals(this.amount) && tpn.category.matches(this.category);
        }
        return false;
    }
}

