/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader;

import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.data.ItemWriteData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.TaxableNotification;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.NonNullSupplier;

public class SlotMachineTradeNotification
extends TaxableNotification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "slot_machine_trade");
    TraderCategory traderData;
    List<ItemWriteData> items;
    CoinValue cost = CoinValue.EMPTY;
    CoinValue money = CoinValue.EMPTY;
    String customer;

    protected SlotMachineTradeNotification(SlotMachineEntry entry, CoinValue cost, PlayerReference customer, TraderCategory traderData, CoinValue taxesPaid) {
        super(taxesPaid);
        this.traderData = traderData;
        this.cost = cost;
        this.items = new ArrayList<ItemWriteData>();
        if (entry.isMoney()) {
            this.money = entry.getMoneyValue();
        } else {
            for (ItemStack item : InventoryUtil.combineQueryItems(entry.items)) {
                this.items.add(new ItemWriteData(item));
            }
        }
        this.customer = customer.getName(false);
    }

    public static NonNullSupplier<Notification> create(SlotMachineEntry entry, CoinValue cost, PlayerReference customer, TraderCategory traderData, CoinValue taxesPaid) {
        return () -> new SlotMachineTradeNotification(entry, cost, customer, traderData, taxesPaid);
    }

    public SlotMachineTradeNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    @Nonnull
    public MutableComponent getNormalMessage() {
        Object rewardText = this.money.hasAny() ? this.money.getComponent("0") : ItemWriteData.getItemNames(this.items);
        return EasyText.translatable("notifications.message.slot_machine_trade", this.customer, this.cost.getString("0"), rewardText);
    }

    @Override
    protected void saveNormal(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        ListTag itemList = new ListTag();
        for (ItemWriteData item : this.items) {
            itemList.add((Object)item.save());
        }
        compound.m_128365_("Items", (Tag)itemList);
        compound.m_128365_("Money", (Tag)this.money.save());
        compound.m_128365_("Price", (Tag)this.cost.save());
        compound.m_128359_("Customer", this.customer);
    }

    @Override
    protected void loadNormal(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        ListTag itemList = compound.m_128437_("Items", 10);
        this.items = new ArrayList<ItemWriteData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(new ItemWriteData(itemList.m_128728_(i)));
        }
        this.money = CoinValue.safeLoad(compound, "Money");
        this.cost = CoinValue.safeLoad(compound, "Price");
        this.customer = compound.m_128461_("Customer");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof SlotMachineTradeNotification) {
            SlotMachineTradeNotification smtn = (SlotMachineTradeNotification)other;
            if (!smtn.traderData.matches(this.traderData)) {
                return false;
            }
            if (smtn.items.size() != this.items.size()) {
                return false;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                ItemWriteData i1 = this.items.get(i);
                ItemWriteData i2 = smtn.items.get(i);
                if (!i1.itemName.getString().equals(i2.itemName.getString())) {
                    return false;
                }
                if (i1.count == i2.count) continue;
                return false;
            }
            if (smtn.money.getValueNumber() != this.money.getValueNumber()) {
                return false;
            }
            if (smtn.cost.getValueNumber() != this.cost.getValueNumber()) {
                return false;
            }
            if (!smtn.customer.equals(this.customer)) {
                return false;
            }
            return this.TaxesMatch(smtn);
        }
        return false;
    }
}

