/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.taxes.data;

import io.github.lightman314.lightmanscurrency.common.taxes.data.WorldPosition;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class WorldArea {
    public static final WorldArea VOID = new WorldArea(null, BlockPos.f_121853_, 0, 0, 0);
    public static final WorldArea INFINITE_VOID = new WorldArea(null, BlockPos.f_121853_, 0, 0, 0);
    private final WorldPosition center;
    private boolean infiniteRange = false;
    private final BlockPos corner1;
    private final BlockPos corner2;

    public final WorldPosition getCenter() {
        return this.center;
    }

    public final boolean isVoid() {
        return this.center.isVoid();
    }

    public boolean isInfiniteRange() {
        return this.infiniteRange;
    }

    public final BlockPos getCorner1() {
        return this.corner1;
    }

    public final BlockPos getCorner2() {
        return this.corner2;
    }

    public final boolean isInArea(@Nonnull BlockPos pos) {
        return this.infiniteRange || MathUtil.WithinBounds(pos, this.corner1, this.corner2);
    }

    public final boolean isInArea(@Nonnull WorldPosition position) {
        if (this.isVoid()) {
            return true;
        }
        if (position.isVoid()) {
            return false;
        }
        return this.center.getDimension().equals(position.getDimension()) && this.isInArea(position.getPos());
    }

    private WorldArea(@Nullable ResourceKey<Level> dimension) {
        this.center = WorldPosition.of(dimension, null);
        this.corner1 = BlockPos.f_121853_;
        this.corner2 = BlockPos.f_121853_;
        this.infiniteRange = true;
    }

    private WorldArea(@Nullable ResourceKey<Level> dimension, @Nullable BlockPos center, int radius, int height, int vertOffset) {
        this.center = WorldPosition.of(dimension, center);
        this.corner1 = this.center.getPos().m_142386_(radius).m_142383_(radius).m_6630_(vertOffset);
        this.corner2 = this.center.getPos().m_142385_(radius).m_142390_(radius).m_6630_(height - 1).m_6630_(vertOffset);
    }

    public static WorldArea ofInfiniteRange(@Nonnull WorldPosition center) {
        if (center.isVoid()) {
            return INFINITE_VOID;
        }
        return new WorldArea(center.getDimension());
    }

    public static WorldArea of(@Nonnull WorldPosition center, int horizRadius, int vertSize, int vertOffset) {
        if (center.isVoid()) {
            return VOID;
        }
        return new WorldArea(center.getDimension(), center.getPos(), horizRadius, vertSize, vertOffset);
    }

    public static WorldArea of(@Nonnull Level level, BlockPos center, int horizRadius, int vertSize, int vertOffset) {
        return new WorldArea((ResourceKey<Level>)level.m_46472_(), center, horizRadius, vertSize, vertOffset);
    }
}

