/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.taxes.reference;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.taxes.reference.TaxableReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public abstract class TaxReferenceType {
    private static final Map<ResourceLocation, TaxReferenceType> types = new HashMap<ResourceLocation, TaxReferenceType>();
    protected final ResourceLocation typeID;

    @Nullable
    public static TaxReferenceType getType(ResourceLocation type) {
        return types.get(type);
    }

    protected TaxReferenceType(ResourceLocation typeID) {
        this.typeID = typeID;
    }

    public static void register(TaxReferenceType type) {
        ResourceLocation id = type.typeID;
        if (types.containsKey(id)) {
            LightmansCurrency.LogWarning("Attempted to register the TaxReferenceType '" + id + "' twice!");
        } else {
            types.put(id, type);
            LightmansCurrency.LogDebug("Registered TaxReferenceType '" + id + "'!");
        }
    }

    public abstract TaxableReference load(CompoundTag var1);
}

