/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.tickets;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class TicketSaveData
extends SavedData {
    private long nextID = 0L;
    private final Map<UUID, Long> convertedIDs = new HashMap<UUID, Long>();

    private TicketSaveData() {
    }

    private TicketSaveData(CompoundTag compound) {
        this.nextID = compound.m_128454_("NextID");
        if (compound.m_128441_("ConvertedIDs")) {
            ListTag list = compound.m_128437_("ConvertedIDs", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag entry = list.m_128728_(i);
                UUID uuid = entry.m_128342_("UUID");
                long id = entry.m_128454_("ID");
                this.convertedIDs.put(uuid, id);
            }
        }
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag compound) {
        compound.m_128356_("NextID", this.nextID);
        ListTag list = new ListTag();
        this.convertedIDs.forEach((uuid, id) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128362_("UUID", uuid);
            entry.m_128356_("ID", id.longValue());
            list.add((Object)entry);
        });
        if (list.size() > 0) {
            compound.m_128365_("ConvertedIDs", (Tag)list);
        }
        return compound;
    }

    private static TicketSaveData get() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return (TicketSaveData)server.m_129783_().m_8895_().m_164861_(TicketSaveData::new, TicketSaveData::new, "lightmanscurrency_ticket_data");
        }
        return null;
    }

    private long createNextIDInternal() {
        long id = this.nextID++;
        this.m_77762_();
        return id;
    }

    public static long createNextID() {
        TicketSaveData tsd = TicketSaveData.get();
        if (tsd != null) {
            return tsd.createNextIDInternal();
        }
        return 0L;
    }

    public static long getConvertedID(UUID oldID) {
        TicketSaveData tsd = TicketSaveData.get();
        if (tsd != null) {
            if (tsd.convertedIDs.containsKey(oldID)) {
                return tsd.convertedIDs.get(oldID);
            }
            tsd.convertedIDs.put(oldID, tsd.createNextIDInternal());
            tsd.m_77762_();
            return tsd.convertedIDs.get(oldID);
        }
        return 0L;
    }
}

