/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traderinterface.handlers;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.common.traderinterface.handlers.SidedHandler;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public abstract class ConfigurableSidedHandler<H>
extends SidedHandler<H> {
    protected final DirectionalSettings inputSides;
    protected final DirectionalSettings outputSides;
    protected static final String UPDATE_INPUT_SIDE = "inputSide";
    protected static final String UPDATE_OUTPUT_SIDE = "outputSide";

    public DirectionalSettings getInputSides() {
        return this.inputSides;
    }

    public DirectionalSettings getOutputSides() {
        return this.outputSides;
    }

    protected ConfigurableSidedHandler() {
        this((ImmutableList<Direction>)ImmutableList.of());
    }

    protected ConfigurableSidedHandler(ImmutableList<Direction> ignoreSides) {
        this.inputSides = new DirectionalSettings(ignoreSides);
        this.outputSides = new DirectionalSettings(ignoreSides);
    }

    public void toggleInputSide(@Nonnull Direction side) {
        this.inputSides.set(side, !this.inputSides.get(side));
        this.markDirty();
        if (this.isClient()) {
            CompoundTag message = ConfigurableSidedHandler.initUpdateInfo(UPDATE_INPUT_SIDE);
            message.m_128405_("side", side.m_122411_());
            message.m_128379_("newValue", this.inputSides.get(side));
            this.sendMessage(message);
        }
    }

    public static CompoundTag initUpdateInfo(String updateType) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("UpdateType", updateType);
        return compound;
    }

    public static boolean isUpdateType(CompoundTag updateInfo, String updateType) {
        if (updateInfo.m_128425_("UpdateType", 8)) {
            return updateInfo.m_128461_("UpdateType").contentEquals(updateType);
        }
        return false;
    }

    public void toggleOutputSide(Direction side) {
        this.outputSides.set(side, !this.outputSides.get(side));
        this.markDirty();
        if (this.isClient()) {
            CompoundTag message = ConfigurableSidedHandler.initUpdateInfo(UPDATE_OUTPUT_SIDE);
            message.m_128405_("side", side.m_122411_());
            message.m_128379_("newValue", this.outputSides.get(side));
            this.sendMessage(message);
        }
    }

    @Override
    public void receiveMessage(CompoundTag compound) {
        if (ConfigurableSidedHandler.isUpdateType(compound, UPDATE_INPUT_SIDE)) {
            Direction side = Direction.m_122376_((int)compound.m_128451_("side"));
            if (compound.m_128471_("newValue") != this.inputSides.get(side)) {
                this.toggleInputSide(side);
            }
        } else if (ConfigurableSidedHandler.isUpdateType(compound, UPDATE_OUTPUT_SIDE)) {
            Direction side = Direction.m_122376_((int)compound.m_128451_("side"));
            if (compound.m_128471_("newValue") != this.outputSides.get(side)) {
                this.toggleOutputSide(side);
            }
        }
    }

    @Override
    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("InputSides", (Tag)this.inputSides.save(new CompoundTag()));
        compound.m_128365_("OutputSides", (Tag)this.outputSides.save(new CompoundTag()));
        this.saveAdditional(compound);
        return compound;
    }

    protected void saveAdditional(CompoundTag compound) {
    }

    @Override
    public void load(CompoundTag compound) {
        if (compound.m_128425_("InputSides", 10)) {
            this.inputSides.load(compound.m_128469_("InputSides"));
        }
        if (compound.m_128425_("OutputSides", 10)) {
            this.outputSides.load(compound.m_128469_("OutputSides"));
        }
    }

    public static class DirectionalSettings {
        public final ImmutableList<Direction> ignoreSides;
        private final Map<Direction, Boolean> sideValues = new HashMap<Direction, Boolean>();

        public DirectionalSettings() {
            this((ImmutableList<Direction>)ImmutableList.of());
        }

        public DirectionalSettings(ImmutableList<Direction> ignoreSides) {
            this.ignoreSides = ignoreSides;
        }

        public boolean allows(Direction side) {
            return !this.ignoreSides.contains((Object)side);
        }

        public boolean get(Direction side) {
            if (this.ignoreSides.contains((Object)side)) {
                return false;
            }
            return this.sideValues.getOrDefault(side, false);
        }

        public void set(Direction side, boolean value) {
            if (this.ignoreSides.contains((Object)side)) {
                return;
            }
            this.sideValues.put(side, value);
        }

        public CompoundTag save(CompoundTag compound) {
            for (Direction side : Direction.values()) {
                if (this.ignoreSides.contains((Object)side)) continue;
                compound.m_128379_(side.toString(), this.get(side));
            }
            return compound;
        }

        public void load(CompoundTag compound) {
            this.sideValues.clear();
            for (Direction side : Direction.values()) {
                if (this.ignoreSides.contains((Object)side) || !compound.m_128441_(side.toString())) continue;
                this.set(side, compound.m_128471_(side.toString()));
            }
        }
    }
}

