/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.input.InputTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.input.InputTabAddon;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.BooleanPermission;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class InputTraderData
extends TraderData {
    public final ImmutableList<Direction> ignoreSides;
    private final Map<Direction, Boolean> inputSides = new HashMap<Direction, Boolean>();
    private final Map<Direction, Boolean> outputSides = new HashMap<Direction, Boolean>();

    public static MutableComponent getFacingName(Direction side) {
        return EasyText.translatable("gui.lightmanscurrency.settings.side." + side.toString().toLowerCase(), new Object[0]);
    }

    @Override
    protected void modifyDefaultAllyPermissions(Map<String, Integer> defaultValues) {
        defaultValues.put("changeExternalInputs", 1);
    }

    protected InputTraderData(ResourceLocation type) {
        this(type, (ImmutableList<Direction>)ImmutableList.of());
    }

    protected InputTraderData(ResourceLocation type, ImmutableList<Direction> ignoreSides) {
        super(type);
        this.ignoreSides = ignoreSides;
    }

    protected InputTraderData(ResourceLocation type, Level level, BlockPos pos) {
        this(type, level, pos, (ImmutableList<Direction>)ImmutableList.of());
    }

    protected InputTraderData(ResourceLocation type, Level level, BlockPos pos, ImmutableList<Direction> ignoreSides) {
        super(type, level, pos);
        this.ignoreSides = ignoreSides;
    }

    public boolean allowInputSide(Direction side) {
        if (this.ignoreSides.contains((Object)side)) {
            return false;
        }
        return this.inputSides.getOrDefault(side, false);
    }

    public final boolean hasInputSide() {
        for (Direction side : Direction.values()) {
            if (!this.allowInputSide(side)) continue;
            return true;
        }
        return false;
    }

    public boolean allowOutputSide(Direction side) {
        if (this.ignoreSides.contains((Object)side)) {
            return false;
        }
        return this.outputSides.getOrDefault(side, false);
    }

    public final boolean hasOutputSide() {
        for (Direction side : Direction.values()) {
            if (!this.allowOutputSide(side)) continue;
            return true;
        }
        return false;
    }

    public void setInputSide(Player player, Direction side, boolean value) {
        if (this.hasPermission(player, "changeExternalInputs") && value != this.allowInputSide(side)) {
            if (this.ignoreSides.contains((Object)side)) {
                return;
            }
            this.inputSides.put(side, value);
            this.markDirty(this::saveInputSides);
            if (player != null) {
                this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "Input-" + InputTraderData.getFacingName(side).getString(), String.valueOf(this.allowInputSide(side))));
            }
        }
    }

    public void setOutputSide(Player player, Direction side, boolean value) {
        if (this.hasPermission(player, "changeExternalInputs") && value != this.allowOutputSide(side)) {
            if (this.ignoreSides.contains((Object)side)) {
                return;
            }
            this.outputSides.put(side, value);
            this.markDirty(this::saveOutputSides);
            if (player != null) {
                this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "Output-" + InputTraderData.getFacingName(side).getString(), String.valueOf(this.allowOutputSide(side))));
            }
        }
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        this.saveInputSides(compound);
        this.saveOutputSides(compound);
    }

    protected final void saveInputSides(CompoundTag compound) {
        CompoundTag tag = new CompoundTag();
        for (Direction side : Direction.values()) {
            if (this.ignoreSides.contains((Object)side)) continue;
            tag.m_128379_(side.toString(), this.allowInputSide(side));
        }
        compound.m_128365_("InputSides", (Tag)tag);
    }

    protected final void saveOutputSides(CompoundTag compound) {
        CompoundTag tag = new CompoundTag();
        for (Direction side : Direction.values()) {
            if (this.ignoreSides.contains((Object)side)) continue;
            tag.m_128379_(side.toString(), this.allowOutputSide(side));
        }
        compound.m_128365_("OutputSides", (Tag)tag);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        CompoundTag tag;
        if (compound.m_128441_("InputSides")) {
            this.inputSides.clear();
            tag = compound.m_128469_("InputSides");
            for (Direction side : Direction.values()) {
                if (this.ignoreSides.contains((Object)side) || !tag.m_128441_(side.toString())) continue;
                this.inputSides.put(side, tag.m_128471_(side.toString()));
            }
        }
        if (compound.m_128441_("OutputSides")) {
            this.outputSides.clear();
            tag = compound.m_128469_("OutputSides");
            for (Direction side : Direction.values()) {
                if (this.ignoreSides.contains((Object)side) || !tag.m_128441_(side.toString())) continue;
                this.outputSides.put(side, tag.m_128471_(side.toString()));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract IconData inputSettingsTabIcon();

    @OnlyIn(value=Dist.CLIENT)
    public abstract MutableComponent inputSettingsTabTooltip();

    @OnlyIn(value=Dist.CLIENT)
    public List<? extends InputTabAddon> inputSettingsAddons() {
        return ImmutableList.of();
    }

    @Override
    public void handleSettingsChange(@Nonnull Player player, @Nonnull LazyPacketData message) {
        Direction side;
        boolean newValue;
        super.handleSettingsChange(player, message);
        if (message.contains("SetInputSide")) {
            newValue = message.getBoolean("SetInputSide");
            side = Direction.m_122376_((int)message.getInt("Side"));
            this.setInputSide(player, side, newValue);
        }
        if (message.contains("SetOutputSide")) {
            newValue = message.getBoolean("SetOutputSide");
            side = Direction.m_122376_((int)message.getInt("Side"));
            this.setOutputSide(player, side, newValue);
        }
    }

    @Override
    @Deprecated(since="2.1.2.4")
    public void receiveNetworkMessage(@Nonnull Player player, @Nonnull CompoundTag message) {
        Direction side;
        boolean newValue;
        super.receiveNetworkMessage(player, message);
        if (message.m_128441_("SetInputSide")) {
            newValue = message.m_128471_("SetInputSide");
            side = Direction.m_122376_((int)message.m_128451_("Side"));
            this.setInputSide(player, side, newValue);
        }
        if (message.m_128441_("SetOutputSide")) {
            newValue = message.m_128471_("SetOutputSide");
            side = Direction.m_122376_((int)message.m_128451_("Side"));
            this.setOutputSide(player, side, newValue);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addSettingsTabs(TraderSettingsClientTab tab, List<SettingsSubTab> tabs) {
        tabs.add(new InputTab(tab));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addPermissionOptions(List<PermissionOption> options) {
        options.add(BooleanPermission.of("changeExternalInputs"));
    }

    @Deprecated
    protected final void loadOldInputSides(CompoundTag compound) {
        this.inputSides.clear();
        for (Direction side : Direction.values()) {
            if (this.ignoreSides.contains((Object)side) || !compound.m_128441_(side.toString())) continue;
            this.inputSides.put(side, compound.m_128471_(side.toString()));
        }
    }

    @Deprecated
    protected final void loadOldOutputSides(CompoundTag compound) {
        this.outputSides.clear();
        for (Direction side : Direction.values()) {
            if (this.ignoreSides.contains((Object)side) || !compound.m_128441_(side.toString())) continue;
            this.outputSides.put(side, compound.m_128471_(side.toString()));
        }
    }
}

