/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders;

import io.github.lightman314.lightmanscurrency.common.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.ICanCopy;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.InteractionSlot;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.CoinValueHolder;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TradeContext {
    public final boolean isStorageMode;
    private final TraderData trader;
    private final Player player;
    private final PlayerReference playerReference;
    private final BankReference bankAccount;
    private final Container coinSlots;
    private final CoinValueHolder storedMoney;
    private final InteractionSlot interactionSlot;
    private final IItemHandler itemHandler;
    private final IFluidHandler fluidTank;
    private final IEnergyStorage energyTank;

    public boolean hasTrader() {
        return this.trader != null;
    }

    public TraderData getTrader() {
        return this.trader;
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean hasPlayerReference() {
        return this.playerReference != null;
    }

    public final PlayerReference getPlayerReference() {
        return this.playerReference;
    }

    private boolean hasBankAccount() {
        return this.bankAccount != null && this.bankAccount.get() != null;
    }

    private boolean hasCoinSlots() {
        return this.hasPlayer() && this.coinSlots != null;
    }

    private boolean hasStoredMoney() {
        return this.storedMoney != null;
    }

    private boolean hasInteractionSlot(String type) {
        return this.getInteractionSlot(type) != null;
    }

    private InteractionSlot getInteractionSlot(String type) {
        if (this.interactionSlot == null) {
            return null;
        }
        if (this.interactionSlot.isType(type)) {
            return this.interactionSlot;
        }
        return null;
    }

    private boolean hasItemHandler() {
        return this.itemHandler != null;
    }

    private boolean hasFluidTank() {
        return this.fluidTank != null;
    }

    private boolean hasEnergyTank() {
        return this.energyTank != null;
    }

    private TradeContext(Builder builder) {
        this.isStorageMode = builder.storageMode;
        this.trader = builder.trader;
        this.player = builder.player;
        this.playerReference = builder.playerReference;
        this.bankAccount = builder.bankAccount;
        this.coinSlots = builder.coinSlots;
        this.storedMoney = builder.storedCoins;
        this.interactionSlot = builder.interactionSlot;
        this.itemHandler = builder.itemHandler;
        this.fluidTank = builder.fluidHandler;
        this.energyTank = builder.energyHandler;
    }

    public boolean hasPaymentMethod() {
        return this.hasPlayer() || this.hasCoinSlots() || this.hasBankAccount() || this.hasStoredMoney();
    }

    public boolean hasFunds(CoinValue price) {
        if (price.isFree() || price.getValueNumber() <= 0L) {
            return true;
        }
        return this.getAvailableFunds() >= price.getValueNumber();
    }

    public long getAvailableFunds() {
        ItemStack wallet;
        IWalletHandler walletHandler;
        long funds = 0L;
        if (this.hasBankAccount()) {
            funds += this.bankAccount.get().getCoinStorage().getValueNumber();
        }
        if (this.hasPlayer() && (walletHandler = WalletCapability.lazyGetWalletHandler((Entity)this.player)) != null && WalletItem.isWallet((wallet = walletHandler.getWallet()).m_41720_())) {
            funds += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        if (this.hasStoredMoney()) {
            funds += this.storedMoney.getValue().getValueNumber();
        }
        if (this.hasCoinSlots() && this.hasPlayer()) {
            funds += MoneyUtil.getValue(this.coinSlots);
        }
        return funds;
    }

    public List<Component> getAvailableFundsDescription() {
        ItemStack wallet;
        IWalletHandler walletHandler;
        ArrayList<Component> text = new ArrayList<Component>();
        if (this.hasCoinSlots() && this.hasPlayer()) {
            this.addToFundsTooltip(text, "tooltip.lightmanscurrency.trader.info.money.slots", MoneyUtil.getCoinValue(this.coinSlots));
        }
        if (this.hasStoredMoney()) {
            this.addToFundsTooltip(text, "tooltip.lightmanscurrency.trader.info.money.coin_storage", this.storedMoney.getValue());
        }
        if (this.hasBankAccount()) {
            this.addToFundsTooltip(text, "tooltip.lightmanscurrency.trader.info.money.bank", this.bankAccount.get().getCoinStorage());
        }
        if (this.hasPlayer() && (walletHandler = WalletCapability.lazyGetWalletHandler((Entity)this.player)) != null && WalletItem.isWallet(wallet = walletHandler.getWallet())) {
            this.addToFundsTooltip(text, "tooltip.lightmanscurrency.trader.info.money.wallet", MoneyUtil.getCoinValue(WalletItem.getWalletInventory(wallet)));
        }
        return text;
    }

    private void addToFundsTooltip(List<Component> text, String translation, CoinValue value) {
        if (value.isValid()) {
            text.add((Component)EasyText.translatable(translation, value.getString()));
        }
    }

    public boolean getPayment(CoinValue price) {
        if (price.isFree() || price.getValueNumber() <= 0L) {
            return true;
        }
        if (this.hasFunds(price)) {
            ItemStack wallet;
            IWalletHandler walletHandler;
            long amountToWithdraw = price.getValueNumber();
            if (this.hasCoinSlots() && this.hasPlayer() && (amountToWithdraw = MoneyUtil.takeObjectsOfValue(amountToWithdraw, this.coinSlots, true)) < 0L) {
                List<ItemStack> change = MoneyUtil.getCoinsOfValue(-amountToWithdraw);
                for (ItemStack stack : change) {
                    ItemStack c = InventoryUtil.TryPutItemStack(this.coinSlots, stack);
                    if (c.m_41619_()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)c);
                }
            }
            if (this.hasStoredMoney() && amountToWithdraw > 0L) {
                long removeAmount = Math.min(amountToWithdraw, this.storedMoney.getValue().getValueNumber());
                amountToWithdraw -= removeAmount;
                this.storedMoney.setValue(CoinValue.fromNumber(this.storedMoney.getValue().getValueNumber() - removeAmount));
            }
            if (this.hasBankAccount() && amountToWithdraw > 0L) {
                CoinValue withdrawAmount = this.bankAccount.get().withdrawCoins(CoinValue.fromNumber(amountToWithdraw));
                amountToWithdraw -= withdrawAmount.getValueNumber();
                if (this.hasTrader() && withdrawAmount.getValueNumber() > 0L) {
                    this.bankAccount.get().LogInteraction(this.getTrader(), withdrawAmount, false);
                }
            }
            if (this.hasPlayer() && amountToWithdraw > 0L && (walletHandler = WalletCapability.lazyGetWalletHandler((Entity)this.player)) != null && WalletItem.isWallet((wallet = walletHandler.getWallet()).m_41720_())) {
                NonNullList<ItemStack> walletInventory = WalletItem.getWalletInventory(wallet);
                long change = MoneyUtil.takeObjectsOfValue(amountToWithdraw, walletInventory, true);
                WalletItem.putWalletInventory(wallet, walletInventory);
                if (change < 0L) {
                    for (ItemStack stack : MoneyUtil.getCoinsOfValue(-change)) {
                        ItemStack c = WalletItem.PickupCoin(wallet, stack);
                        if (c.m_41619_()) continue;
                        ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)c);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean givePayment(CoinValue price) {
        if (price.isFree()) {
            return true;
        }
        if (this.hasBankAccount()) {
            this.bankAccount.get().depositCoins(price);
            if (this.hasTrader()) {
                this.bankAccount.get().LogInteraction(this.getTrader(), price, true);
            }
            return true;
        }
        if (this.hasStoredMoney()) {
            this.storedMoney.setValue(this.storedMoney.getValue().plusValue(price));
            return true;
        }
        if (this.hasPlayer()) {
            ItemStack wallet;
            List<ItemStack> coins = MoneyUtil.getCoinsOfValue(price);
            ArrayList<Object> change = new ArrayList<ItemStack>(coins);
            IWalletHandler walletHandler = WalletCapability.lazyGetWalletHandler((Entity)this.player);
            if (walletHandler != null && WalletItem.isWallet((wallet = walletHandler.getWallet()).m_41720_())) {
                change = new ArrayList();
                for (ItemStack itemStack : coins) {
                    ItemStack coin = WalletItem.PickupCoin(wallet, itemStack);
                    if (coin.m_41619_()) continue;
                    change.add(coin);
                }
            }
            if (this.hasCoinSlots() && change.size() > 0) {
                for (ItemStack itemStack : change) {
                    ItemStack remainder = InventoryUtil.TryPutItemStack(this.coinSlots, itemStack);
                    if (remainder.m_41619_()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)remainder);
                }
            } else if (change.size() > 0) {
                for (ItemStack itemStack : change) {
                    ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)itemStack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean hasItem(ItemStack item) {
        if (this.hasItemHandler()) {
            return InventoryUtil.CanExtractItem(this.itemHandler, item);
        }
        if (this.hasPlayer()) {
            return InventoryUtil.GetItemCount((Container)this.player.m_150109_(), item) >= item.m_41613_();
        }
        return false;
    }

    public boolean hasItems(ItemStack ... items) {
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean hasItems(List<ItemStack> items) {
        if (items == null) {
            return false;
        }
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean hasItems(ItemRequirement ... requirements) {
        if (this.hasItemHandler()) {
            return ItemRequirement.getFirstItemsMatchingRequirements(this.itemHandler, requirements) != null;
        }
        if (this.hasPlayer()) {
            return ItemRequirement.getFirstItemsMatchingRequirements((Container)this.player.m_150109_(), requirements) != null;
        }
        return false;
    }

    public boolean hasTicket(long ticketID) {
        block3: {
            block2: {
                if (!this.hasItemHandler()) break block2;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    long id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (stack.m_41720_() != ModItems.TICKET.get() || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                    ItemStack copyStack = stack.m_41777_();
                    copyStack.m_41764_(1);
                    if (!InventoryUtil.CanExtractItem(this.itemHandler, copyStack)) continue;
                    return true;
                }
                break block3;
            }
            if (!this.hasPlayer()) break block3;
            Inventory inventory = this.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                long id;
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41720_() != ModItems.TICKET.get() || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPass(long ticketID) {
        block3: {
            block2: {
                if (!this.hasItemHandler()) break block2;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    long id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (stack.m_41720_() != ModItems.TICKET_PASS.get() || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                    return true;
                }
                break block3;
            }
            if (!this.hasPlayer()) break block3;
            Inventory inventory = this.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                long id;
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41720_() != ModItems.TICKET_PASS.get() || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                return true;
            }
        }
        return false;
    }

    public boolean collectItem(ItemStack item) {
        if (this.hasItem(item)) {
            if (this.hasItemHandler()) {
                InventoryUtil.RemoveItemCount(this.itemHandler, item);
                return true;
            }
            if (this.hasPlayer()) {
                InventoryUtil.RemoveItemCount((Container)this.player.m_150109_(), item);
                return true;
            }
        }
        return false;
    }

    public boolean collectItems(List<ItemStack> items) {
        items = InventoryUtil.combineQueryItems(items);
        for (ItemStack item : items) {
            if (this.hasItem(item)) continue;
            return false;
        }
        for (ItemStack item : items) {
            this.collectItem(item);
        }
        return true;
    }

    public List<ItemStack> getCollectableItems(ItemRequirement ... requirements) {
        if (this.hasItemHandler()) {
            return ItemRequirement.getFirstItemsMatchingRequirements(this.itemHandler, requirements);
        }
        if (this.hasPlayer()) {
            return ItemRequirement.getFirstItemsMatchingRequirements((Container)this.player.m_150109_(), requirements);
        }
        return null;
    }

    public void hightlightItems(List<ItemRequirement> requirements, NonNullList<Slot> slots, List<Integer> results) {
        if (this.hasPlayer()) {
            HashMap<Integer, Integer> inventoryConsumedCounts = new HashMap<Integer, Integer>();
            Inventory inventory = this.player.m_150109_();
            for (ItemRequirement requirement : requirements) {
                int amountToConsume = requirement.count;
                for (int i = 0; i < inventory.m_6643_() && amountToConsume > 0; ++i) {
                    ItemStack stack = inventory.m_8020_(i);
                    if (!requirement.test(stack) || stack.m_41619_()) continue;
                    int alreadyConsumed = inventoryConsumedCounts.getOrDefault(i, 0);
                    int consumeCount = Math.min(amountToConsume, stack.m_41613_() - alreadyConsumed);
                    amountToConsume -= consumeCount;
                    if ((alreadyConsumed += consumeCount) <= 0) continue;
                    inventoryConsumedCounts.put(i, alreadyConsumed);
                }
            }
            Iterator<ItemRequirement> iterator = inventoryConsumedCounts.keySet().iterator();
            while (iterator.hasNext()) {
                int relevantSlot = (Integer)((Object)iterator.next());
                for (int i = 0; i < slots.size(); ++i) {
                    Slot slot = (Slot)slots.get(i);
                    if (slot.f_40218_ != inventory || slot.m_150661_() != relevantSlot) continue;
                    results.add(i);
                }
            }
        }
    }

    public boolean collectTicket(long ticketID) {
        block2: {
            block3: {
                if (!this.hasTicket(ticketID)) break block2;
                if (!this.hasItemHandler()) break block3;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    long id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (stack.m_41720_() != ModItems.TICKET.get() || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                    ItemStack extractStack = stack.m_41777_();
                    extractStack.m_41764_(1);
                    if (!InventoryUtil.RemoveItemCount(this.itemHandler, extractStack)) continue;
                    return true;
                }
                break block2;
            }
            if (!this.hasPlayer()) break block2;
            Inventory inventory = this.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                long id;
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41720_() != ModItems.TICKET.get() || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                inventory.m_7407_(i, 1);
                inventory.m_6596_();
                return true;
            }
        }
        return false;
    }

    public boolean canFitItem(ItemStack item) {
        if (item.m_41619_()) {
            return true;
        }
        if (this.hasItemHandler()) {
            return ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)item, (boolean)true).m_41619_();
        }
        return this.hasPlayer();
    }

    public boolean canFitItems(ItemStack ... items) {
        if (this.hasItemHandler()) {
            IItemHandler copy;
            IItemHandler original = this.itemHandler;
            if (original instanceof ICanCopy) {
                copy = (IItemHandler)((ICanCopy)original).copy();
            } else {
                NonNullList inventory = NonNullList.m_122780_((int)original.getSlots(), (Object)ItemStack.f_41583_);
                for (int i = 0; i < original.getSlots(); ++i) {
                    inventory.set(i, (Object)original.getStackInSlot(i));
                }
                copy = new ItemStackHandler(inventory);
            }
            for (ItemStack item : items) {
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)copy, (ItemStack)item, (boolean)false).m_41619_()) continue;
                return false;
            }
            return true;
        }
        return this.hasPlayer();
    }

    public boolean canFitItems(List<ItemStack> items) {
        if (this.hasItemHandler()) {
            IItemHandler original = this.itemHandler;
            IItemHandler copy = null;
            if (original instanceof ICanCopy) {
                try {
                    copy = (IItemHandler)((ICanCopy)original).copy();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (copy == null) {
                NonNullList inventory = NonNullList.m_122780_((int)original.getSlots(), (Object)ItemStack.f_41583_);
                for (int i = 0; i < original.getSlots(); ++i) {
                    inventory.set(i, (Object)original.getStackInSlot(i));
                }
                copy = new ItemStackHandler(inventory);
            }
            for (ItemStack item : items) {
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)copy, (ItemStack)item, (boolean)false).m_41619_()) continue;
                return false;
            }
            return true;
        }
        return this.hasPlayer();
    }

    public boolean putItem(ItemStack item) {
        if (this.canFitItem(item)) {
            if (this.hasItemHandler()) {
                ItemStack leftovers = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)item, (boolean)false);
                if (leftovers.m_41619_()) {
                    return true;
                }
                ItemStack placedStack = item.m_41777_();
                placedStack.m_41764_(item.m_41613_() - leftovers.m_41613_());
                if (!item.m_41619_()) {
                    this.collectItem(placedStack);
                }
                return false;
            }
            if (this.hasPlayer()) {
                ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)item);
                return true;
            }
        }
        return false;
    }

    public boolean hasFluid(FluidStack fluid) {
        if (this.hasFluidTank()) {
            FluidStack result = this.fluidTank.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
            return !result.isEmpty() && result.getAmount() >= fluid.getAmount();
        }
        if (this.hasInteractionSlot("BUCKET_SLOT")) {
            ItemStack bucketStack = this.getInteractionSlot("BUCKET_SLOT").m_7993_();
            AtomicBoolean hasFluid = new AtomicBoolean(false);
            FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                FluidStack result = fluidHandler.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
                hasFluid.set(!result.isEmpty() && result.getAmount() == fluid.getAmount());
            });
            return hasFluid.get();
        }
        return false;
    }

    public boolean drainFluid(FluidStack fluid) {
        if (this.hasFluid(fluid)) {
            if (this.hasFluidTank()) {
                this.fluidTank.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            if (this.hasInteractionSlot("BUCKET_SLOT")) {
                InteractionSlot slot = this.getInteractionSlot("BUCKET_SLOT");
                ItemStack bucketStack = slot.m_7993_();
                FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                    fluidHandler.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
                    slot.m_5852_(fluidHandler.getContainer());
                });
                return true;
            }
        }
        return false;
    }

    public boolean canFitFluid(FluidStack fluid) {
        if (this.hasFluidTank()) {
            return this.fluidTank.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount();
        }
        if (this.hasInteractionSlot("BUCKET_SLOT")) {
            ItemStack bucketStack = this.getInteractionSlot("BUCKET_SLOT").m_7993_();
            AtomicBoolean fitFluid = new AtomicBoolean(false);
            FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> fitFluid.set(fluidHandler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount()));
            return fitFluid.get();
        }
        return false;
    }

    public boolean fillFluid(FluidStack fluid) {
        if (this.canFitFluid(fluid)) {
            if (this.hasFluidTank()) {
                this.fluidTank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            if (this.hasInteractionSlot("BUCKET_SLOT")) {
                InteractionSlot slot = this.getInteractionSlot("BUCKET_SLOT");
                ItemStack bucketStack = slot.m_7993_();
                FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                    fluidHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                    slot.m_5852_(fluidHandler.getContainer());
                });
            }
        }
        return false;
    }

    public boolean hasEnergy(int amount) {
        if (this.hasEnergyTank()) {
            return this.energyTank.extractEnergy(amount, true) == amount;
        }
        if (this.hasInteractionSlot("ENERGY_SLOT")) {
            ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
            AtomicBoolean hasEnergy = new AtomicBoolean(false);
            batteryStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyHandler -> hasEnergy.set(energyHandler.extractEnergy(amount, true) == amount));
            return hasEnergy.get();
        }
        return false;
    }

    public boolean drainEnergy(int amount) {
        if (this.hasEnergy(amount)) {
            if (this.hasEnergyTank()) {
                this.energyTank.extractEnergy(amount, false);
                return true;
            }
            if (this.hasInteractionSlot("ENERGY_SLOT")) {
                ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
                batteryStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyHandler -> energyHandler.extractEnergy(amount, false));
                return true;
            }
        }
        return false;
    }

    public boolean canFitEnergy(int amount) {
        if (this.hasEnergyTank()) {
            return this.energyTank.receiveEnergy(amount, true) == amount;
        }
        if (this.hasInteractionSlot("ENERGY_SLOT")) {
            ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
            AtomicBoolean fitsEnergy = new AtomicBoolean(false);
            batteryStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyHandler -> fitsEnergy.set(energyHandler.receiveEnergy(amount, true) == amount));
            return fitsEnergy.get();
        }
        return false;
    }

    public boolean fillEnergy(int amount) {
        if (this.canFitEnergy(amount)) {
            if (this.hasEnergyTank()) {
                this.energyTank.receiveEnergy(amount, false);
                return true;
            }
            if (this.hasInteractionSlot("ENERGY_SLOT")) {
                ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").m_7993_();
                batteryStack.getCapability(CapabilityEnergy.ENERGY).ifPresent(energyHandler -> energyHandler.receiveEnergy(amount, false));
                return true;
            }
        }
        return false;
    }

    public static TradeContext createStorageMode(TraderData trader) {
        return new Builder(trader).build();
    }

    public static Builder create(TraderData trader, Player player) {
        return new Builder(trader, player);
    }

    public static Builder create(TraderData trader, PlayerReference player) {
        return new Builder(trader, player);
    }

    public static class Builder {
        private final boolean storageMode;
        private final TraderData trader;
        private final Player player;
        private final PlayerReference playerReference;
        private BankReference bankAccount;
        private Container coinSlots;
        private CoinValueHolder storedCoins;
        private InteractionSlot interactionSlot;
        private IItemHandler itemHandler;
        private IFluidHandler fluidHandler;
        private IEnergyStorage energyHandler;

        private Builder(TraderData trader) {
            this.storageMode = true;
            this.trader = trader;
            this.player = null;
            this.playerReference = null;
        }

        private Builder(TraderData trader, Player player) {
            this.trader = trader;
            this.player = player;
            this.playerReference = PlayerReference.of(player);
            this.storageMode = false;
        }

        private Builder(TraderData trader, PlayerReference player) {
            this.trader = trader;
            this.playerReference = player;
            this.player = null;
            this.storageMode = false;
        }

        public Builder withBankAccount(BankReference bankAccount) {
            this.bankAccount = bankAccount;
            return this;
        }

        public Builder withCoinSlots(Container coinSlots) {
            this.coinSlots = coinSlots;
            return this;
        }

        public Builder withStoredCoins(CoinValueHolder storedCoins) {
            this.storedCoins = storedCoins;
            return this;
        }

        public Builder withInteractionSlot(InteractionSlot interactionSlot) {
            this.interactionSlot = interactionSlot;
            return this;
        }

        public Builder withItemHandler(IItemHandler itemHandler) {
            this.itemHandler = itemHandler;
            return this;
        }

        public Builder withFluidHandler(IFluidHandler fluidHandler) {
            this.fluidHandler = fluidHandler;
            return this;
        }

        public Builder withEnergyHandler(IEnergyStorage energyHandler) {
            this.energyHandler = energyHandler;
            return this;
        }

        public TradeContext build() {
            return new TradeContext(this);
        }
    }

    public static enum TradeResult {
        SUCCESS(null),
        FAIL_OUT_OF_STOCK("lightmanscurrency.remotetrade.fail.nostock"),
        FAIL_CANNOT_AFFORD("lightmanscurrency.remotetrade.fail.cantafford"),
        FAIL_NO_OUTPUT_SPACE("lightmanscurrency.remotetrade.fail.nospace.output"),
        FAIL_NO_INPUT_SPACE("lightmanscurrency.remotetrade.fail.nospace.input"),
        FAIL_TRADE_RULE_DENIAL("lightmanscurrency.remotetrade.fail.traderule"),
        FAIL_TAX_EXCEEDED_LIMIT("lightmanscurrency.remotetrade.fail.tax_limit"),
        FAIL_INVALID_TRADE("lightmanscurrency.remotetrade.fail.invalid"),
        FAIL_NOT_SUPPORTED("lightmanscurrency.remotetrade.fail.notsupported"),
        FAIL_NULL("lightmanscurrency.remotetrade.fail.null");

        public final Component failMessage;

        public boolean isSuccess() {
            return this.failMessage == null;
        }

        public boolean hasMessage() {
            return this.failMessage != null;
        }

        private TradeResult(String message) {
            this.failMessage = message == null ? null : EasyText.translatable(message, new Object[0]);
        }
    }
}

