/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.TraderSettingsClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.AllyTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.MainTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.NotificationTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.OwnershipTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.PermissionsTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.TaxSettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.interfaces.IDeprecatedBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.IDumpable;
import io.github.lightman314.lightmanscurrency.common.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.common.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menus.providers.EasyMenuProvider;
import io.github.lightman314.lightmanscurrency.common.menus.validation.EasyMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.CoinValueHolder;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationSaveData;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveAllyNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeAllyPermissionNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeCreativeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeNameNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeOwnerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.ChangeSettingNotification;
import io.github.lightman314.lightmanscurrency.common.ownership.OwnerData;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.taxes.ITaxable;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxManager;
import io.github.lightman314.lightmanscurrency.common.taxes.data.WorldPosition;
import io.github.lightman314.lightmanscurrency.common.taxes.reference.TaxableReference;
import io.github.lightman314.lightmanscurrency.common.taxes.reference.types.TaxableTraderReference;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.ITraderSource;
import io.github.lightman314.lightmanscurrency.common.traders.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.BooleanPermission;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.options.PermissionOption;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import io.github.lightman314.lightmanscurrency.network.message.trader.SPacketSyncUsers;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class TraderData
implements IClientTracker,
IDumpable,
UpgradeType.IUpgradeable,
ITraderSource,
ITradeRuleHost,
ITaxable {
    public static final int GLOBAL_TRADE_LIMIT = 100;
    private boolean canMarkDirty = false;
    public final ResourceLocation type;
    private long id = -1L;
    private boolean alwaysShowOnTerminal = false;
    private boolean creative = false;
    private boolean isClient = false;
    private final OwnerData owner = new OwnerData(this, o -> this.markDirty(this::saveOwner));
    private final List<PlayerReference> allies = new ArrayList<PlayerReference>();
    private final Map<String, Integer> allyPermissions = this.getDefaultAllyPermissions();
    private final NotificationData logger = new NotificationData();
    private String customName = "";
    private Item traderBlock;
    private final CoinValueHolder storedMoney = new CoinValueHolder(() -> this.markDirty(this::saveStoredMoney));
    private boolean linkedToBank = false;
    private SimpleContainer upgrades;
    private List<TradeRule> rules = new ArrayList<TradeRule>();
    private boolean notificationsEnabled = false;
    private boolean notificationsToChat = true;
    private int teamNotificationLevel = 0;
    private int acceptableTaxRate = 99;
    private final List<Long> ignoredTaxCollectors = new ArrayList<Long>();
    private boolean ignoreAllTaxes = false;
    private WorldPosition worldPosition = WorldPosition.VOID;
    private String persistentID = "";
    private static final Map<String, NonNullSupplier<TraderData>> deserializers = new HashMap<String, NonNullSupplier<TraderData>>();
    private int userCount = 0;
    private final List<Player> currentUsers = new ArrayList<Player>();

    public final TraderData allowMarkingDirty() {
        this.canMarkDirty = true;
        return this;
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public void setAlwaysShowOnTerminal() {
        this.alwaysShowOnTerminal = true;
        this.markDirty(this::saveShowOnTerminal);
    }

    public boolean shouldAlwaysShowOnTerminal() {
        return this.alwaysShowOnTerminal;
    }

    public boolean canShowOnTerminal() {
        return true;
    }

    public boolean showOnTerminal() {
        if (this.alwaysShowOnTerminal) {
            return true;
        }
        return this.hasNetworkUpgrade();
    }

    protected final boolean hasNetworkUpgrade() {
        return UpgradeType.hasUpgrade(UpgradeType.NETWORK, (Container)this.upgrades);
    }

    public void setCreative(Player player, boolean creative) {
        if (this.hasPermission(player, "LC_ADMIN_MODE") && this.creative != creative) {
            this.creative = creative;
            this.markDirty(this::saveCreative);
            if (player != null) {
                this.pushLocalNotification(new ChangeCreativeNotification(PlayerReference.of(player), this.creative));
            }
        }
    }

    public boolean isCreative() {
        return this.creative;
    }

    public void flagAsClient() {
        this.isClient = true;
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    @Override
    public final OwnerData getOwner() {
        return this.owner;
    }

    public final List<PlayerReference> getAllies() {
        return new ArrayList<PlayerReference>(this.allies);
    }

    private Map<String, Integer> getDefaultAllyPermissions() {
        HashMap<String, Integer> defaultValues = new HashMap<String, Integer>();
        defaultValues.put("openStorage", 1);
        defaultValues.put("editTrades", 1);
        defaultValues.put("editTradeRules", 1);
        defaultValues.put("editSettings", 1);
        defaultValues.put("changeName", 1);
        defaultValues.put("viewLogs", 1);
        defaultValues.put("notifications", 1);
        this.modifyDefaultAllyPermissions(defaultValues);
        return defaultValues;
    }

    protected void modifyDefaultAllyPermissions(Map<String, Integer> defaultValues) {
    }

    protected List<String> getBlockedPermissions() {
        return ImmutableList.of();
    }

    public boolean hasPermission(Player player, String permission) {
        return this.getPermissionLevel(player, permission) > 0;
    }

    public boolean hasPermission(PlayerReference player, String permission) {
        return this.getPermissionLevel(player, permission) > 0;
    }

    public int getPermissionLevel(Player player, String permission) {
        if (this.isPersistent() && player != null && this.persistentTraderBlockedPermissions().contains((Object)permission)) {
            return 0;
        }
        if (player != null && this.getBlockedPermissions().contains(permission)) {
            return 0;
        }
        if (this.isAdmin(player)) {
            return Integer.MAX_VALUE;
        }
        if (this.isAlly(player)) {
            return this.getAllyPermissionLevel(permission);
        }
        return 0;
    }

    public int getPermissionLevel(PlayerReference player, String permission) {
        if (this.isPersistent() && player != null && this.persistentTraderBlockedPermissions().contains((Object)permission)) {
            return 0;
        }
        if (player != null && this.getBlockedPermissions().contains(permission)) {
            return 0;
        }
        if (this.isAdmin(player)) {
            return Integer.MAX_VALUE;
        }
        if (this.isAlly(player)) {
            return this.getAllyPermissionLevel(permission);
        }
        return 0;
    }

    private ImmutableList<String> persistentTraderBlockedPermissions() {
        ArrayList blockedPermissions = Lists.newArrayList((Object[])new String[]{"editTrades", "editSettings", "interactionLink", "transferOwnership", "collectCoins", "storeCoins"});
        this.blockPermissionsForPersistentTrader(blockedPermissions);
        return ImmutableList.copyOf((Collection)blockedPermissions);
    }

    protected void blockPermissionsForPersistentTrader(List<String> list) {
    }

    public int getAllyPermissionLevel(String permission) {
        return this.allyPermissions.getOrDefault(permission, 0);
    }

    public void setAllyPermissionLevel(Player player, String permission, int level) {
        if (this.hasPermission(player, "editPermissions") && this.getAllyPermissionLevel(permission) != level) {
            int oldLevel = this.getAllyPermissionLevel(permission);
            this.allyPermissions.put(permission, level);
            this.markDirty(this::saveAllyPermissions);
            if (player != null) {
                this.pushLocalNotification(new ChangeAllyPermissionNotification(PlayerReference.of(player), permission, level, oldLevel));
            }
        }
    }

    private boolean isAdmin(Player player) {
        return player == null || this.owner.isAdmin(player);
    }

    private boolean isAdmin(PlayerReference player) {
        return player == null || this.owner.isAdmin(player);
    }

    private boolean isAlly(Player player) {
        if (this.owner.isMember(player)) {
            return true;
        }
        return PlayerReference.isInList(this.allies, (Entity)player);
    }

    private boolean isAlly(PlayerReference player) {
        if (this.owner.isMember(player)) {
            return true;
        }
        return PlayerReference.isInList(this.allies, player);
    }

    public final List<Notification> getNotifications() {
        return this.logger.getNotifications();
    }

    public boolean hasCustomName() {
        return !this.customName.isBlank();
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(Player player, String name) {
        if (this.hasPermission(player, "changeName") && !this.customName.equals(name)) {
            String oldName = this.customName;
            this.customName = name;
            this.markDirty(this::saveName);
            if (player != null) {
                this.pushLocalNotification(new ChangeNameNotification(PlayerReference.of(player), this.customName, oldName));
            }
        }
    }

    public abstract IconData getIcon();

    @Override
    public MutableComponent getName() {
        if (this.hasCustomName()) {
            return EasyText.literal(this.customName);
        }
        return this.getDefaultName();
    }

    public final MutableComponent getTitle() {
        if (this.creative) {
            return this.getName();
        }
        return EasyText.translatable("gui.lightmanscurrency.trading.title", this.getName(), this.owner.getOwnerName(this.isClient));
    }

    protected MutableComponent getDefaultName() {
        if (this.traderBlock != null) {
            return EasyText.literal(new ItemStack((ItemLike)this.traderBlock).m_41786_().getString());
        }
        return EasyText.translatable("gui.lightmanscurrency.universaltrader.default", new Object[0]);
    }

    public CoinValue getStoredMoney() {
        BankAccount ba = this.getBankAccount();
        if (ba != null) {
            return ba.getCoinStorage();
        }
        return this.getInternalStoredMoney();
    }

    public CoinValue getInternalStoredMoney() {
        return this.storedMoney.getValue();
    }

    @Deprecated(since="2.1.2.2")
    public void addStoredMoney(CoinValue amount) {
        this.addStoredMoney(amount, true);
    }

    public CoinValue addStoredMoney(CoinValue amount, boolean shouldTax) {
        BankAccount ba;
        CoinValue taxesPaid = CoinValue.EMPTY;
        if (shouldTax) {
            taxesPaid = this.payTaxesOn(amount);
            if (amount.getValueNumber() < taxesPaid.getValueNumber()) {
                this.removeStoredMoney(taxesPaid.minusValue(amount), false);
                return taxesPaid;
            }
            if (!(amount = amount.minusValue(taxesPaid)).hasAny()) {
                return taxesPaid;
            }
        }
        if ((ba = this.getBankAccount()) != null) {
            ba.depositCoins(amount);
            ba.LogInteraction(this, amount, true);
            return taxesPaid;
        }
        this.storedMoney.addValue(amount);
        return taxesPaid;
    }

    @Deprecated(since="2.1.2.2")
    public void removeStoredMoney(CoinValue amount) {
        this.removeStoredMoney(amount, true);
    }

    public CoinValue removeStoredMoney(CoinValue amount, boolean shouldTax) {
        BankAccount ba;
        CoinValue taxesPaid = CoinValue.EMPTY;
        if (shouldTax && (taxesPaid = this.payTaxesOn(amount)).hasAny()) {
            amount = amount.plusValue(taxesPaid);
        }
        if ((ba = this.getBankAccount()) != null) {
            ba.withdrawCoins(amount);
            ba.LogInteraction(this, amount, false);
            return taxesPaid;
        }
        this.storedMoney.removeValue(amount);
        return taxesPaid;
    }

    public void clearStoredMoney() {
        this.storedMoney.clear();
    }

    public final CoinValue payTaxesOn(CoinValue amount) {
        long paidCache = 0L;
        for (TaxEntry tax : this.getApplicableTaxes()) {
            if (this.ShouldIgnoreTaxEntry(tax)) continue;
            paidCache += tax.CalculateAndPayTaxes(this, amount).getValueNumber();
        }
        return CoinValue.fromNumber(paidCache);
    }

    public boolean getLinkedToBank() {
        return this.linkedToBank;
    }

    public boolean canLinkBankAccount() {
        if (this.owner.hasTeam()) {
            return this.owner.getTeam().hasBankAccount();
        }
        return true;
    }

    public void setLinkedToBank(Player player, boolean linkedToBank) {
        if (this.hasPermission(player, "bankLink") && linkedToBank != this.linkedToBank) {
            this.linkedToBank = linkedToBank;
            if (this.linkedToBank) {
                BankAccount account = this.getBankAccount();
                if (account != null) {
                    account.depositCoins(this.storedMoney.getValue());
                    this.storedMoney.clear();
                } else {
                    this.linkedToBank = false;
                }
            }
            this.markDirty(this::saveLinkedBankAccount);
            if (player != null) {
                this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "BankLink", String.valueOf(this.linkedToBank)));
            }
        }
    }

    public boolean hasBankAccount() {
        return this.getBankAccount() != null;
    }

    public BankAccount getBankAccount() {
        if (this.linkedToBank) {
            PlayerReference player;
            Team team;
            if (this.owner.hasTeam() && (team = this.owner.getTeam()) != null && team.hasBankAccount()) {
                return team.getBankAccount();
            }
            if (this.owner.hasPlayer() && (player = this.owner.getPlayer()) != null) {
                return BankSaveData.GetBankAccount(this.isClient, player.id);
            }
        }
        return null;
    }

    public Container getUpgrades() {
        return this.upgrades;
    }

    @Override
    public final boolean allowUpgrade(UpgradeType type) {
        if (!this.showOnTerminal() && this.canShowOnTerminal() && type == UpgradeType.NETWORK) {
            return true;
        }
        return this.allowAdditionalUpgradeType(type);
    }

    protected abstract boolean allowAdditionalUpgradeType(UpgradeType var1);

    @Override
    @Nonnull
    public List<TradeRule> getRules() {
        return Lists.newArrayList(this.rules);
    }

    protected void validateRules() {
        TradeRule.ValidateTradeRuleList(this.rules, this);
    }

    public boolean notificationsEnabled() {
        return this.notificationsEnabled;
    }

    public boolean notificationsToChat() {
        return this.notificationsToChat;
    }

    public int teamNotificationLevel() {
        return this.teamNotificationLevel;
    }

    public abstract int getTradeCount();

    public boolean canEditTradeCount() {
        return false;
    }

    public int getMaxTradeCount() {
        return 1;
    }

    public abstract int getTradeStock(int var1);

    public abstract boolean hasValidTrade();

    public final int getAcceptableTaxRate() {
        return this.acceptableTaxRate;
    }

    public boolean ShouldIgnoreAllTaxes() {
        return this.ignoreAllTaxes;
    }

    public boolean ShouldIgnoreTaxEntryOnly(@Nonnull TaxEntry entry) {
        return this.ignoredTaxCollectors.contains(entry.getID());
    }

    public void FlagTaxEntryToIgnore(@Nonnull TaxEntry entry, @Nonnull Player player) {
        if (this.ignoredTaxCollectors.contains(entry.getID())) {
            return;
        }
        if (!LCAdminMode.isAdminPlayer(player)) {
            Permissions.PermissionWarning(player, "ignore tax collector", "LC_ADMIN_MODE");
            return;
        }
        this.ignoredTaxCollectors.add(entry.getID());
        this.markDirty(this::saveTaxSettings);
    }

    public void PardonTaxEntry(@Nonnull TaxEntry entry) {
        if (this.ignoredTaxCollectors.contains(entry.getID())) {
            this.ignoredTaxCollectors.remove(entry.getID());
            this.markDirty(this::saveTaxSettings);
        }
    }

    private boolean AllowTaxEntry(@Nonnull TaxEntry entry) {
        return !this.ShouldIgnoreTaxEntry(entry);
    }

    public boolean ShouldIgnoreTaxEntry(@Nonnull TaxEntry entry) {
        return this.ShouldIgnoreAllTaxes() || this.ShouldIgnoreTaxEntryOnly(entry);
    }

    public ResourceKey<Level> getLevel() {
        return this.worldPosition.getDimension();
    }

    public BlockPos getPos() {
        return this.worldPosition.getPos();
    }

    @Override
    public TaxableReference getReference() {
        return new TaxableTraderReference(this.getID());
    }

    @Override
    public WorldPosition getWorldPosition() {
        return this.worldPosition;
    }

    public final List<TaxEntry> getApplicableTaxes() {
        return TaxManager.GetTaxesForTrader(this).stream().filter(this::AllowTaxEntry).toList();
    }

    public final List<TaxEntry> getPossibleTaxes() {
        return TaxManager.GetPossibleTaxesForTrader(this);
    }

    public final int getTotalTaxPercentage() {
        List<TaxEntry> entries = this.getApplicableTaxes();
        int taxPercentage = 0;
        for (TaxEntry entry : entries) {
            taxPercentage += entry.getTaxRate();
        }
        return taxPercentage;
    }

    public final boolean exceedsAcceptableTaxRate() {
        return this.getTotalTaxPercentage() > this.acceptableTaxRate;
    }

    public void move(Level level, BlockPos pos) {
        this.worldPosition = WorldPosition.ofLevel(level, pos);
        if (this.id >= 0L) {
            this.markDirty(this::saveLevelData);
        }
    }

    protected TraderData(ResourceLocation type) {
        this.type = type;
        this.upgrades = new SimpleContainer(5);
        this.upgrades.m_19164_(c -> this.markDirty(this::saveUpgrades));
    }

    protected TraderData(ResourceLocation type, Level level, BlockPos pos) {
        this(type);
        this.worldPosition = WorldPosition.ofLevel(level, pos);
        this.traderBlock = level == null ? (Item)ModItems.TRADING_CORE.get() : level.m_8055_(this.worldPosition.getPos()).m_60734_().m_5456_();
    }

    public boolean isPersistent() {
        return this.persistentID.length() > 0;
    }

    public String getPersistentID() {
        return this.persistentID;
    }

    public void makePersistent(long id, String persistentID) {
        this.id = id;
        this.persistentID = persistentID;
        this.creative = true;
        this.alwaysShowOnTerminal = true;
    }

    protected final void markDirty(CompoundTag updateData) {
        if (this.isClient || !this.canMarkDirty) {
            return;
        }
        updateData.m_128356_("ID", this.id);
        TraderSaveData.MarkTraderDirty(updateData);
    }

    @SafeVarargs
    protected final void markDirty(Consumer<CompoundTag> ... updateWriters) {
        if (this.isClient || !this.canMarkDirty) {
            return;
        }
        CompoundTag updateData = new CompoundTag();
        for (Consumer<CompoundTag> u : updateWriters) {
            u.accept(updateData);
        }
        this.markDirty(updateData);
    }

    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("Type", this.type.toString());
        compound.m_128356_("ID", this.id);
        this.saveLevelData(compound);
        this.saveTraderItem(compound);
        this.saveOwner(compound);
        this.saveAllies(compound);
        this.saveAllyPermissions(compound);
        this.saveName(compound);
        this.saveCreative(compound);
        this.saveShowOnTerminal(compound);
        this.saveRules(compound);
        this.saveUpgrades(compound);
        this.saveStoredMoney(compound);
        this.saveLinkedBankAccount(compound);
        this.saveLogger(compound);
        this.saveNotificationData(compound);
        this.saveTaxSettings(compound);
        if (this.persistentID.length() > 0) {
            compound.m_128359_("PersistentTraderID", this.persistentID);
        }
        this.saveAdditional(compound);
        return compound;
    }

    public final void saveLevelData(CompoundTag compound) {
        compound.m_128365_("Location", (Tag)this.worldPosition.save());
    }

    private void saveTraderItem(CompoundTag compound) {
        if (this.traderBlock != null) {
            compound.m_128359_("TraderBlock", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.traderBlock).toString());
        }
    }

    protected final void saveOwner(CompoundTag compound) {
        compound.m_128365_("OwnerData", (Tag)this.owner.save());
    }

    protected final void saveAllies(CompoundTag compound) {
        PlayerReference.saveList(compound, this.allies, "Allies");
    }

    protected final void saveAllyPermissions(CompoundTag compound) {
        ListTag allyPermList = new ListTag();
        this.allyPermissions.forEach((perm, level) -> {
            CompoundTag tag = new CompoundTag();
            if (level != 0) {
                tag.m_128359_("Permission", perm);
                tag.m_128405_("Level", level.intValue());
                allyPermList.add((Object)tag);
            }
        });
        compound.m_128365_("AllyPermissions", (Tag)allyPermList);
    }

    protected final void saveName(CompoundTag compound) {
        compound.m_128359_("Name", this.customName);
    }

    protected final void saveCreative(CompoundTag compound) {
        compound.m_128379_("Creative", this.creative);
    }

    protected final void saveShowOnTerminal(CompoundTag compound) {
        compound.m_128379_("AlwaysShowOnTerminal", this.alwaysShowOnTerminal);
    }

    protected final void saveRules(CompoundTag compound) {
        TradeRule.saveRules(compound, this.rules, "RuleData");
    }

    protected final void saveUpgrades(CompoundTag compound) {
        InventoryUtil.saveAllItems("Upgrades", compound, (Container)this.upgrades);
    }

    protected final void saveStoredMoney(CompoundTag compound) {
        compound.m_128365_("StoredMoney", (Tag)this.storedMoney.save());
    }

    protected final void saveLinkedBankAccount(CompoundTag compound) {
        compound.m_128379_("LinkedToBank", this.linkedToBank);
    }

    protected final void saveLogger(CompoundTag compound) {
        compound.m_128365_("Logger", (Tag)this.logger.save());
    }

    protected final void saveNotificationData(CompoundTag compound) {
        compound.m_128379_("NotificationsEnabled", this.notificationsEnabled);
        compound.m_128379_("ChatNotifications", this.notificationsToChat);
        compound.m_128405_("TeamNotifications", this.teamNotificationLevel);
    }

    protected final void saveTaxSettings(CompoundTag compound) {
        compound.m_128405_("AcceptableTaxRate", this.acceptableTaxRate);
        compound.m_128379_("IgnoreAllTaxCollectors", this.ignoreAllTaxes);
        compound.m_128428_("IgnoreTaxCollectors", this.ignoredTaxCollectors);
    }

    protected abstract void saveTrades(CompoundTag var1);

    protected abstract void saveAdditional(CompoundTag var1);

    public void markTradesDirty() {
        this.markDirty(this::saveTrades);
    }

    @Override
    public void markTradeRulesDirty() {
        this.markDirty(this::saveRules);
    }

    public final JsonObject saveToJson(String id, String ownerName) throws Exception {
        if (!this.canMakePersistent()) {
            throw new Exception("Trader of type '" + this.type.toString() + "' cannot be saved to JSON!");
        }
        JsonObject json = new JsonObject();
        json.addProperty("Type", this.type.toString());
        json.addProperty("ID", id);
        json.addProperty("Name", this.hasCustomName() ? this.customName : "Trader");
        json.addProperty("OwnerName", ownerName);
        JsonArray ruleData = TradeRule.saveRulesToJson(this.rules);
        if (ruleData.size() > 0) {
            json.add("Rules", (JsonElement)ruleData);
        }
        this.saveAdditionalToJson(json);
        return json;
    }

    protected abstract void saveAdditionalToJson(JsonObject var1);

    public final void load(CompoundTag compound) {
        if (compound.m_128425_("ID", 4)) {
            this.setID(compound.m_128454_("ID"));
        }
        if (compound.m_128441_("PersistentTraderID")) {
            this.persistentID = compound.m_128461_("PersistentTraderID");
        }
        if (compound.m_128441_("WorldPos") && compound.m_128441_("Level")) {
            CompoundTag posTag = compound.m_128469_("WorldPos");
            BlockPos pos = new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z"));
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("Level")));
            this.worldPosition = WorldPosition.of((ResourceKey<Level>)dimension, pos);
        } else if (compound.m_128441_("Location")) {
            this.worldPosition = WorldPosition.load(compound.m_128469_("Location"));
        }
        if (compound.m_128441_("TraderBlock")) {
            try {
                IDeprecatedBlock db;
                Block b;
                BlockItem bi;
                Block block;
                Item traderBlock = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(compound.m_128461_("TraderBlock")));
                if (traderBlock instanceof BlockItem && (block = (bi = (BlockItem)traderBlock).m_40614_()) instanceof IDeprecatedBlock && (b = (db = (IDeprecatedBlock)block).replacementBlock()) != null) {
                    traderBlock = b.m_5456_();
                }
                this.traderBlock = traderBlock;
            }
            catch (Throwable traderBlock) {
                // empty catch block
            }
        }
        if (compound.m_128425_("OwnerData", 10)) {
            this.owner.load(compound.m_128469_("OwnerData"));
        }
        if (compound.m_128441_("Allies")) {
            this.allies.clear();
            this.allies.addAll(PlayerReference.loadList(compound, "Allies"));
        }
        if (compound.m_128441_("AllyPermissions")) {
            this.allyPermissions.clear();
            ListTag allyPermList = compound.m_128437_("AllyPermissions", 10);
            for (int i = 0; i < allyPermList.size(); ++i) {
                CompoundTag tag = allyPermList.m_128728_(i);
                String perm = tag.m_128461_("Permission");
                int level = tag.m_128451_("Level");
                this.allyPermissions.put(perm, level);
            }
        }
        if (compound.m_128441_("Name")) {
            this.customName = compound.m_128461_("Name");
        }
        if (compound.m_128441_("Creative")) {
            this.creative = compound.m_128471_("Creative");
        }
        if (compound.m_128441_("AlwaysShowOnTerminal")) {
            this.alwaysShowOnTerminal = compound.m_128471_("AlwaysShowOnTerminal");
        }
        if (compound.m_128441_("RuleData")) {
            this.rules = TradeRule.loadRules(compound, "RuleData", this);
        }
        if (compound.m_128441_("Upgrades")) {
            this.upgrades = InventoryUtil.loadAllItems("Upgrades", compound, 5);
            this.upgrades.m_19164_(c -> this.markDirty(this::saveUpgrades));
        }
        if (compound.m_128441_("StoredMoney")) {
            this.storedMoney.safeLoad(compound, "StoredMoney");
        }
        if (compound.m_128441_("LinkedToBank")) {
            this.linkedToBank = compound.m_128471_("LinkedToBank");
        }
        if (compound.m_128441_("Logger")) {
            this.logger.load(compound.m_128469_("Logger"));
        }
        if (compound.m_128441_("NotificationsEnabled")) {
            this.notificationsEnabled = compound.m_128471_("NotificationsEnabled");
        }
        if (compound.m_128441_("ChatNotifications")) {
            this.notificationsToChat = compound.m_128471_("ChatNotifications");
        }
        if (compound.m_128441_("TeamNotifications")) {
            this.teamNotificationLevel = compound.m_128451_("TeamNotifications");
        }
        if (compound.m_128441_("AcceptableTaxRate")) {
            this.acceptableTaxRate = compound.m_128451_("AcceptableTaxRate");
        }
        if (compound.m_128441_("IgnoreAllTaxCollectors")) {
            this.ignoreAllTaxes = compound.m_128471_("IgnoreAllTaxCollectors");
        }
        if (compound.m_128441_("IgnoreTaxCollectors")) {
            this.ignoredTaxCollectors.clear();
            for (long val : compound.m_128467_("IgnoreTaxCollectors")) {
                this.ignoredTaxCollectors.add(val);
            }
        }
        this.loadAdditional(compound);
    }

    public void OnRegisteredToOffice() {
        if (this.isServer() && !this.isPersistent()) {
            TradeRule.ValidateTradeRuleList(this.rules, this);
        }
    }

    protected abstract void loadAdditional(CompoundTag var1);

    public final void loadFromJson(JsonObject json) throws Exception {
        if (json.has("OwnerName")) {
            this.owner.SetCustomOwner(json.get("OwnerName").getAsString());
        } else {
            this.owner.SetCustomOwner("Server");
        }
        if (json.has("Name")) {
            this.customName = json.get("Name").getAsString();
        }
        if (json.has("Rules")) {
            this.rules = TradeRule.Parse(json.getAsJsonArray("Rules"), this);
        }
        this.loadAdditionalFromJson(json);
    }

    protected abstract void loadAdditionalFromJson(JsonObject var1) throws Exception;

    public final CompoundTag savePersistentData() {
        CompoundTag compound = new CompoundTag();
        TradeRule.savePersistentData(compound, this.rules, "RuleData");
        this.saveAdditionalPersistentData(compound);
        return compound;
    }

    protected abstract void saveAdditionalPersistentData(CompoundTag var1);

    public final void loadPersistentData(CompoundTag compound) {
        TradeRule.loadPersistentData(compound, this.rules, "RuleData");
        this.loadAdditionalPersistentData(compound);
    }

    protected abstract void loadAdditionalPersistentData(CompoundTag var1);

    @Deprecated(since="2.1.2.3")
    public void openTraderMenu(Player player) {
        this.openTraderMenu(player, SimpleValidator.NULL);
    }

    public void openTraderMenu(Player player, @Nonnull MenuValidator validator) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHooks.openGui((ServerPlayer)sp, (MenuProvider)this.getTraderMenuProvider(validator), EasyMenu.encoder(this.getMenuDataWriter(), validator));
        }
    }

    protected MenuProvider getTraderMenuProvider(@Nonnull MenuValidator validator) {
        return new TraderMenuProvider(this.id, validator);
    }

    @Deprecated(since="2.1.2.3")
    public void openStorageMenu(@Nonnull Player player) {
        this.openStorageMenu(player, SimpleValidator.NULL);
    }

    public void openStorageMenu(@Nonnull Player player, @Nonnull MenuValidator validator) {
        if (!this.hasPermission(player, "openStorage")) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            NetworkHooks.openGui((ServerPlayer)sp, (MenuProvider)this.getTraderStorageMenuProvider(validator), EasyMenu.encoder(this.getMenuDataWriter(), validator));
        }
    }

    protected MenuProvider getTraderStorageMenuProvider(@Nonnull MenuValidator validator) {
        return new TraderStorageMenuProvider(this.id, validator);
    }

    public Consumer<FriendlyByteBuf> getMenuDataWriter() {
        return b -> b.writeLong(this.id);
    }

    public TradeEvent.PreTradeEvent runPreTradeEvent(PlayerReference player, TradeData trade) {
        TradeEvent.PreTradeEvent event = new TradeEvent.PreTradeEvent(player, trade, this);
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.beforeTrade(event);
        }
        trade.beforeTrade(event);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    public TradeEvent.TradeCostEvent runTradeCostEvent(PlayerReference player, TradeData trade) {
        TradeEvent.TradeCostEvent event = new TradeEvent.TradeCostEvent(player, trade, this);
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.tradeCost(event);
        }
        trade.tradeCost(event);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    @Deprecated(since="2.1.2.2")
    public void runPostTradeEvent(PlayerReference player, TradeData trade, CoinValue cost) {
        this.runPostTradeEvent(player, trade, cost, CoinValue.EMPTY);
    }

    public void runPostTradeEvent(PlayerReference player, TradeData trade, CoinValue cost, CoinValue taxesPaid) {
        TradeEvent.PostTradeEvent event = new TradeEvent.PostTradeEvent(player, trade, this, cost, taxesPaid);
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.afterTrade(event);
        }
        if (event.isDirty()) {
            this.markTradeRulesDirty();
        }
        event.clean();
        trade.afterTrade(event);
        if (event.isDirty()) {
            this.markTradesDirty();
        }
        event.clean();
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction relativeSide) {
        return LazyOptional.empty();
    }

    @Override
    public final List<ItemStack> getContents(Level level, BlockPos pos, BlockState state, boolean dropBlock) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        if (dropBlock) {
            ItemStack blockStack;
            Block block = state != null ? state.m_60734_() : null;
            ItemStack itemStack = blockStack = block != null ? new ItemStack((ItemLike)block.m_5456_()) : ItemStack.f_41583_;
            if (block instanceof ITraderBlock) {
                ITraderBlock b = (ITraderBlock)block;
                blockStack = b.getDropBlockItem(level, pos, state);
            }
            if (!blockStack.m_41619_()) {
                results.add(blockStack);
            } else {
                LightmansCurrency.LogWarning("Block drop for trader is empty!");
            }
        }
        for (int i = 0; i < this.upgrades.m_6643_(); ++i) {
            ItemStack stack = this.upgrades.m_8020_(i);
            if (stack.m_41619_()) continue;
            results.add(stack);
        }
        for (CoinValue.CoinValuePair entry : this.storedMoney.getValue().getEntries()) {
            ItemStack stack = new ItemStack((ItemLike)entry.coin, entry.amount);
            while (stack.m_41613_() > stack.m_41741_()) {
                results.add(stack.m_41620_(stack.m_41741_()));
            }
            if (stack.m_41619_()) continue;
            results.add(stack);
        }
        this.getAdditionalContents(results);
        return results;
    }

    protected abstract void getAdditionalContents(List<ItemStack> var1);

    public static void register(ResourceLocation type, @Nonnull NonNullSupplier<TraderData> source) {
        String t = type.toString();
        if (deserializers.containsKey(t)) {
            LightmansCurrency.LogWarning("Attempted to register duplicate TraderData type '" + t + "'!");
            return;
        }
        deserializers.put(t, source);
    }

    public static TraderData Deserialize(boolean isClient, CompoundTag compound) {
        if (compound.m_128441_("Type")) {
            String type = compound.m_128461_("Type");
            if (deserializers.containsKey(type)) {
                TraderData data = (TraderData)deserializers.get(type).get();
                if (isClient) {
                    data.flagAsClient();
                }
                data.load(compound);
                return data;
            }
            LightmansCurrency.LogWarning("Could not deserialize TraderData of type '" + type + "' as no deserializer for that type has been registered!");
            return null;
        }
        LightmansCurrency.LogError("Could not deserialize TraderData as no 'Type' entry was given!");
        return null;
    }

    public static TraderData Deserialize(JsonObject json) throws Exception {
        if (!(json.has("Type") && json.get("Type").isJsonPrimitive() && json.get("Type").getAsJsonPrimitive().isString())) {
            throw new Exception("No string 'Type' entry for this trader.");
        }
        String thisType = json.get("Type").getAsString();
        if (deserializers.containsKey(thisType)) {
            TraderData data = (TraderData)deserializers.get(thisType).get();
            data.loadFromJson(json);
            return data;
        }
        throw new Exception("Trader type '" + thisType + "' is undefined.");
    }

    public boolean shouldRemove(MinecraftServer server) {
        if (this.worldPosition.isVoid()) {
            return false;
        }
        ServerLevel level = server.m_129880_(this.getLevel());
        if (level != null && level.m_46749_(this.getPos())) {
            BlockEntity be = level.m_7702_(this.getPos());
            if (be instanceof TraderBlockEntity) {
                TraderBlockEntity tbe = (TraderBlockEntity)be;
                return tbe.getTraderID() != this.id;
            }
            return true;
        }
        return false;
    }

    public List<Player> getUsers() {
        return new ArrayList<Player>(this.currentUsers);
    }

    public int getUserCount() {
        return this.userCount;
    }

    public void userOpen(Player player) {
        this.currentUsers.add(player);
        this.updateUserCount();
    }

    public void userClose(Player player) {
        this.currentUsers.remove(player);
        this.updateUserCount();
    }

    private void updateUserCount() {
        if (this.isServer()) {
            this.userCount = this.currentUsers.size();
            new SPacketSyncUsers(this.id, this.userCount).sendToAll();
        }
    }

    public void updateUserCount(int userCount) {
        if (this.isClient) {
            this.userCount = userCount;
        }
    }

    @Nonnull
    public abstract List<? extends TradeData> getTradeData();

    @Nullable
    public abstract TradeData getTrade(int var1);

    public int indexOfTrade(TradeData trade) {
        return this.getTradeData().indexOf(trade);
    }

    public abstract void addTrade(Player var1);

    public abstract void removeTrade(Player var1);

    @Override
    public final boolean isTrader() {
        return true;
    }

    @Override
    public final boolean isTrade() {
        return false;
    }

    @Override
    public boolean canMoneyBeRelevant() {
        List<? extends TradeData> trades = this.getTradeData();
        if (trades != null) {
            return trades.stream().anyMatch(ITradeRuleHost::canMoneyBeRelevant);
        }
        return true;
    }

    @Override
    public boolean isMoneyRelevant() {
        return this.canMoneyBeRelevant();
    }

    @Override
    public boolean allowTradeRule(@Nonnull TradeRule rule) {
        return true;
    }

    public final TradeContext.TradeResult TryExecuteTrade(TradeContext context, int tradeIndex) {
        if (this.exceedsAcceptableTaxRate()) {
            return TradeContext.TradeResult.FAIL_TAX_EXCEEDED_LIMIT;
        }
        return this.ExecuteTrade(context, tradeIndex);
    }

    @Deprecated
    public abstract TradeContext.TradeResult ExecuteTrade(TradeContext var1, int var2);

    public abstract void addInteractionSlots(List<InteractionSlotData> var1);

    public abstract boolean canMakePersistent();

    public Function<TradeData, Boolean> getStorageDisplayFilter(TraderStorageMenu menu) {
        return TradeButtonArea.FILTER_ANY;
    }

    public abstract void initStorageTabs(TraderStorageMenu var1);

    public void handleSettingsChange(@Nonnull Player player, @Nonnull LazyPacketData message) {
        boolean newState;
        int level;
        boolean enable;
        boolean enable2;
        PlayerReference oldAlly;
        PlayerReference newAlly;
        Team team;
        PlayerReference oldPlayer;
        Team oldTeam;
        PlayerReference newOwner;
        if (message.contains("ChangePlayerOwner") && this.hasPermission(player, "transferOwnership") && (newOwner = PlayerReference.of(this.isClient, message.getString("ChangePlayerOwner"))) != null && (this.owner.hasTeam() || !newOwner.is(this.owner.getPlayer()))) {
            oldTeam = this.owner.getTeam();
            oldPlayer = this.owner.getPlayer();
            this.owner.SetOwner(newOwner);
            if (this.linkedToBank) {
                this.linkedToBank = false;
                this.markDirty(this::saveLinkedBankAccount);
            }
            if (oldTeam != null) {
                this.pushLocalNotification(new ChangeOwnerNotification(PlayerReference.of(player), newOwner, oldTeam));
            } else if (oldPlayer != null) {
                this.pushLocalNotification(new ChangeOwnerNotification(PlayerReference.of(player), newOwner, oldPlayer));
            }
        }
        if (message.contains("ChangeTeamOwner") && this.hasPermission(player, "transferOwnership") && (team = TeamSaveData.GetTeam(this.isClient, message.getLong("ChangeTeamOwner"))) != null && team.isMember(player) && team != this.owner.getTeam()) {
            oldTeam = this.owner.getTeam();
            oldPlayer = this.owner.getPlayer();
            this.owner.SetOwner(team);
            if (this.linkedToBank) {
                this.linkedToBank = false;
                this.markDirty(this::saveLinkedBankAccount);
            }
            if (oldTeam != null) {
                this.pushLocalNotification(new ChangeOwnerNotification(PlayerReference.of(player), team, oldTeam));
            } else if (oldPlayer != null) {
                this.pushLocalNotification(new ChangeOwnerNotification(PlayerReference.of(player), team, oldPlayer));
            }
        }
        if (message.contains("AddAlly") && this.hasPermission(player, "addRemoveAllies") && (newAlly = PlayerReference.of(this.isClient, message.getString("AddAlly"))) != null && !PlayerReference.isInList(this.allies, newAlly.id)) {
            this.allies.add(newAlly);
            this.markDirty(this::saveAllies);
            this.pushLocalNotification(new AddRemoveAllyNotification(PlayerReference.of(player), true, newAlly));
        }
        if (message.contains("RemoveAlly") && this.hasPermission(player, "addRemoveAllies") && PlayerReference.removeFromList(this.allies, oldAlly = PlayerReference.of(this.isClient, message.getString("RemoveAlly")))) {
            this.markDirty(this::saveAllies);
            this.pushLocalNotification(new AddRemoveAllyNotification(PlayerReference.of(player), false, oldAlly));
        }
        if (message.contains("ChangeAllyPermissions") && this.hasPermission(player, "editPermissions")) {
            String permission = message.getString("ChangeAllyPermissions");
            int newLevel = message.getInt("NewLevel");
            this.setAllyPermissionLevel(player, permission, newLevel);
        }
        if (message.contains("ChangeName")) {
            this.setCustomName(player, message.getString("ChangeName"));
        }
        if (message.contains("MakeCreative")) {
            this.setCreative(player, message.getBoolean("MakeCreative"));
        }
        if (message.contains("LinkToBankAccount")) {
            this.setLinkedToBank(player, message.getBoolean("LinkToBankAccount"));
        }
        if (message.contains("Notifications") && this.hasPermission(player, "notifications") && this.notificationsEnabled != (enable2 = message.getBoolean("Notifications"))) {
            this.notificationsEnabled = enable2;
            this.markDirty(this::saveNotificationData);
            this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "Notifications", String.valueOf(this.notificationsEnabled)));
        }
        if (message.contains("NotificationsToChat") && this.hasPermission(player, "notifications") && this.notificationsToChat != (enable = message.getBoolean("NotificationsToChat"))) {
            this.notificationsToChat = enable;
            this.markDirty(this::saveNotificationData);
            this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "NotificationsToChat", String.valueOf(this.notificationsToChat)));
        }
        if (message.contains("TeamNotificationLevel") && this.hasPermission(player, "notifications") && this.teamNotificationLevel != (level = message.getInt("TeamNotificationLevel"))) {
            this.teamNotificationLevel = level;
            this.markDirty(this::saveNotificationData);
            this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "TeamNotificationLevel", String.valueOf(this.teamNotificationLevel)));
        }
        if (message.contains("TradeRuleEdit") && this.hasPermission(player, "editTradeRules")) {
            ResourceLocation type = new ResourceLocation(message.getString("TradeRuleEdit"));
            int tradeIndex = message.getInt("TradeIndex");
            CompoundTag updateData = message.getNBT("TradeRuleData");
            if (tradeIndex >= 0) {
                try {
                    TradeRule rule;
                    TradeData trade = this.getTradeData().get(tradeIndex);
                    if (trade != null && (rule = TradeRule.getRule(type, trade.getRules())) != null) {
                        rule.receiveUpdateMessage(updateData);
                        this.markTradesDirty();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else {
                TradeRule rule = TradeRule.getRule(type, this.rules);
                if (rule != null) {
                    rule.receiveUpdateMessage(updateData);
                    this.markDirty(this::saveRules);
                }
            }
        }
        if (message.contains("AcceptableTaxRate") && this.hasPermission(player, "editSettings")) {
            int newRate = MathUtil.clamp(message.getInt("AcceptableTaxRate"), 0, 99);
            if (newRate == this.acceptableTaxRate) {
                return;
            }
            this.pushLocalNotification(new ChangeSettingNotification.Advanced(PlayerReference.of(player), "AcceptableTaxRate", String.valueOf(newRate), String.valueOf(this.acceptableTaxRate)));
            this.acceptableTaxRate = newRate;
            this.markDirty(this::saveTaxSettings);
        }
        if (message.contains("ForceIgnoreAllTaxCollectors") && (!(newState = message.getBoolean("ForceIgnoreAllTaxCollectors")) || LCAdminMode.isAdminPlayer(player)) && newState != this.ignoreAllTaxes) {
            this.ignoreAllTaxes = newState;
            this.pushLocalNotification(new ChangeSettingNotification.Simple(PlayerReference.of(player), "IgnoreAllTaxes", String.valueOf(this.ignoreAllTaxes)));
            this.markDirty(this::saveTaxSettings);
        }
    }

    @Deprecated(since="2.1.2.4")
    public void receiveNetworkMessage(@Nonnull Player player, @Nonnull CompoundTag message) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public final List<SettingsSubTab> getSettingsTabs(TraderSettingsClientTab tab) {
        ArrayList tabs = Lists.newArrayList((Object[])new SettingsSubTab[]{new MainTab(tab), new AllyTab(tab), new PermissionsTab(tab), new NotificationTab(tab), new TaxSettingsTab(tab)});
        this.addSettingsTabs(tab, tabs);
        tabs.add(new OwnershipTab(tab));
        return tabs;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addSettingsTabs(TraderSettingsClientTab tab, List<SettingsSubTab> tabs) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public final List<PermissionOption> getPermissionOptions() {
        ArrayList options = Lists.newArrayList((Object[])new PermissionOption[]{BooleanPermission.of("openStorage"), BooleanPermission.of("changeName"), BooleanPermission.of("editTrades"), BooleanPermission.of("collectCoins"), BooleanPermission.of("storeCoins"), BooleanPermission.of("editTradeRules"), BooleanPermission.of("editSettings"), BooleanPermission.of("addRemoveAllies"), BooleanPermission.of("editPermissions"), BooleanPermission.of("viewLogs"), BooleanPermission.of("notifications"), BooleanPermission.of("bankLink"), BooleanPermission.of("breakTrader"), BooleanPermission.of("transferOwnership")});
        if (this.showOnTerminal()) {
            options.add(BooleanPermission.of("interactionLink"));
        }
        this.addPermissionOptions(options);
        this.handleBlockedPermissions(options);
        return options;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void addPermissionOptions(List<PermissionOption> var1);

    @OnlyIn(value=Dist.CLIENT)
    protected final void handleBlockedPermissions(List<PermissionOption> options) {
        for (String blockedPerm : this.getBlockedPermissions()) {
            for (int i = 0; i < options.size(); ++i) {
                if (!Objects.equals(options.get((int)i).permission, blockedPerm)) continue;
                options.remove(i);
                --i;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onScreenInit(TraderScreen screen, Consumer<Object> addWidget) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onStorageScreenInit(TraderStorageScreen screen, Consumer<Object> addWidget) {
    }

    public final void pushLocalNotification(Notification notification) {
        if (this.isClient) {
            return;
        }
        this.logger.addNotification(notification);
        this.markDirty(this::saveLogger);
    }

    @Override
    public final void pushNotification(NonNullSupplier<Notification> notificationSource) {
        if (this.isClient) {
            return;
        }
        this.pushLocalNotification((Notification)notificationSource.get());
        if (!this.notificationsEnabled) {
            return;
        }
        Team team = this.owner.getTeam();
        if (team != null) {
            ArrayList<PlayerReference> sendTo = new ArrayList<PlayerReference>();
            if (this.teamNotificationLevel < 1) {
                sendTo.addAll(team.getMembers());
            }
            if (this.teamNotificationLevel < 2) {
                sendTo.addAll(team.getAdmins());
            }
            sendTo.add(team.getOwner());
            for (PlayerReference player : sendTo) {
                if (player == null || player.id == null) continue;
                NotificationSaveData.PushNotification(player.id, (Notification)notificationSource.get(), this.notificationsToChat);
            }
        } else if (this.owner.hasPlayer()) {
            NotificationSaveData.PushNotification(this.owner.getPlayer().id, (Notification)notificationSource.get(), this.notificationsToChat);
        }
    }

    public final TraderCategory getNotificationCategory() {
        return new TraderCategory((ItemLike)(this.traderBlock != null ? this.traderBlock : (ItemLike)ModItems.TRADING_CORE.get()), this.getName(), this.id);
    }

    @Override
    @Nonnull
    public final List<TraderData> getTraders() {
        return Lists.newArrayList((Object[])new TraderData[]{this});
    }

    @Override
    public final boolean isSingleTrader() {
        return true;
    }

    public static MenuProvider getTraderMenuProvider(@Nonnull BlockPos traderSourcePosition, @Nonnull MenuValidator validator) {
        return new TraderMenuProviderBlock(traderSourcePosition, validator);
    }

    private record TraderMenuProvider(long traderID, @Nonnull MenuValidator validator) implements EasyMenuProvider
    {
        public AbstractContainerMenu m_7208_(int windowID, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new TraderMenu(windowID, inventory, this.traderID, this.validator);
        }
    }

    private record TraderStorageMenuProvider(long traderID, @Nonnull MenuValidator validator) implements EasyMenuProvider
    {
        public AbstractContainerMenu m_7208_(int windowID, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new TraderStorageMenu(windowID, inventory, this.traderID, this.validator);
        }
    }

    private record TraderMenuProviderBlock(@Nonnull BlockPos traderSourcePosition, @Nonnull MenuValidator validator) implements EasyMenuProvider
    {
        public AbstractContainerMenu m_7208_(int windowID, @Nonnull Inventory inventory, @Nonnull Player player) {
            return new TraderMenu.TraderMenuBlockSource(windowID, inventory, this.traderSourcePosition, this.validator);
        }
    }
}

