/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.common.events.AuctionHouseEvent;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationSaveData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBuyerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseCancelNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNobidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNotification;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.common.traders.auction.PersistentAuctionData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.client.AuctionTradeButtonRenderer;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;

public class AuctionTradeData
extends TradeData {
    private boolean cancelled;
    private String persistentID = "";
    CoinValue lastBidAmount = CoinValue.EMPTY;
    PlayerReference lastBidPlayer = null;
    CoinValue minBidDifference = CoinValue.fromNumber(1L);
    PlayerReference tradeOwner;
    long startTime = 0L;
    long duration = 0L;
    List<ItemStack> auctionItems = new ArrayList<ItemStack>();

    public static long GetMinimumDuration() {
        if ((Integer)Config.SERVER.minAuctionDuration.get() > 0) {
            return 86400000L * (long)((Integer)Config.SERVER.minAuctionDuration.get()).intValue();
        }
        return 3600000L;
    }

    public static long GetDefaultDuration() {
        if ((Integer)Config.SERVER.minAuctionDuration.get() > 0) {
            return 86400000L * (long)((Integer)Config.SERVER.minAuctionDuration.get()).intValue();
        }
        return 86400000L;
    }

    public boolean hasBid() {
        return this.lastBidPlayer != null;
    }

    public boolean isPersistentID(String id) {
        return this.persistentID.equals(id);
    }

    public CoinValue getLastBidAmount() {
        return this.lastBidAmount;
    }

    public PlayerReference getLastBidPlayer() {
        return this.lastBidPlayer;
    }

    public void setStartingBid(CoinValue amount) {
        if (this.isActive()) {
            return;
        }
        this.lastBidAmount = amount;
    }

    public CoinValue getMinBidDifference() {
        return this.minBidDifference;
    }

    public void setMinBidDifferent(CoinValue amount) {
        if (this.isActive()) {
            return;
        }
        this.minBidDifference = amount;
        if (this.minBidDifference.getValueNumber() <= 0L) {
            this.minBidDifference = CoinValue.fromNumber(1L);
        }
    }

    public PlayerReference getOwner() {
        return this.tradeOwner;
    }

    public boolean isOwner(Player player) {
        return this.tradeOwner != null && this.tradeOwner.is((Entity)player) || LCAdminMode.isAdminPlayer(player);
    }

    public void setDuration(long duration) {
        if (this.isActive()) {
            return;
        }
        this.duration = Math.max(AuctionTradeData.GetMinimumDuration(), duration);
    }

    public List<ItemStack> getAuctionItems() {
        return this.auctionItems;
    }

    public void setAuctionItems(Container auctionItems) {
        if (this.isActive()) {
            return;
        }
        this.auctionItems.clear();
        for (int i = 0; i < auctionItems.m_6643_(); ++i) {
            ItemStack stack = auctionItems.m_8020_(i);
            if (stack.m_41619_()) continue;
            this.auctionItems.add(stack.m_41777_());
        }
    }

    public AuctionTradeData(Player owner) {
        super(false);
        this.tradeOwner = PlayerReference.of(owner);
        this.setDuration(AuctionTradeData.GetDefaultDuration());
    }

    public AuctionTradeData(CompoundTag compound) {
        super(false);
        this.loadFromNBT(compound);
    }

    public AuctionTradeData(PersistentAuctionData data) {
        super(false);
        this.persistentID = data.id;
        this.setDuration(data.duration);
        this.auctionItems = data.getAuctionItems();
        this.setStartingBid(data.getStartingBid());
        this.setMinBidDifferent(data.getMinimumBidDifference());
    }

    public boolean isActive() {
        return this.startTime != 0L && !this.cancelled;
    }

    @Override
    public boolean isValid() {
        if (this.cancelled) {
            return false;
        }
        if (this.auctionItems.size() == 0) {
            return false;
        }
        if (this.isActive() && this.hasExpired(TimeUtil.getCurrentTime())) {
            return false;
        }
        if (this.minBidDifference.getValueNumber() <= 0L) {
            return false;
        }
        return this.lastBidAmount.getValueNumber() > 0L;
    }

    public void startTimer() {
        if (!this.isActive()) {
            this.startTime = TimeUtil.getCurrentTime();
        }
    }

    public long getRemainingTime(long currentTime) {
        if (!this.isActive()) {
            return this.duration;
        }
        return Math.max(0L, this.startTime + this.duration - currentTime);
    }

    public boolean hasExpired(long time) {
        if (this.isActive()) {
            return time >= this.startTime + this.duration;
        }
        return false;
    }

    public boolean tryMakeBid(AuctionHouseTrader trader, Player player, CoinValue amount) {
        if (!this.validateBidAmount(amount)) {
            return false;
        }
        PlayerReference oldBidder = this.lastBidPlayer;
        if (this.lastBidPlayer != null) {
            AuctionPlayerStorage storage = trader.getStorage(this.lastBidPlayer);
            storage.giveMoney(this.lastBidAmount);
            trader.markStorageDirty();
        }
        this.lastBidPlayer = PlayerReference.of(player);
        this.lastBidAmount = amount;
        if (oldBidder != null) {
            NotificationSaveData.PushNotification(oldBidder.id, new AuctionHouseBidNotification(this));
        }
        return true;
    }

    public boolean validateBidAmount(CoinValue amount) {
        CoinValue minAmount = this.getMinNextBid();
        return amount.getValueNumber() >= minAmount.getValueNumber();
    }

    public CoinValue getMinNextBid() {
        if (this.lastBidPlayer == null) {
            return this.lastBidAmount;
        }
        return this.lastBidAmount.plusValue(this.minBidDifference);
    }

    public void ExecuteTrade(AuctionHouseTrader trader) {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        AuctionHouseEvent.AuctionEvent.AuctionCompletedEvent event = new AuctionHouseEvent.AuctionEvent.AuctionCompletedEvent(trader, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (this.lastBidPlayer != null) {
            AuctionPlayerStorage buyerStorage = trader.getStorage(this.lastBidPlayer);
            List<ItemStack> rewards = event.getItems();
            for (ItemStack reward : rewards) {
                buyerStorage.giveItem(reward);
            }
            if (this.tradeOwner != null) {
                AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner);
                sellerStorage.giveMoney(event.getPayment());
            }
            NotificationSaveData.PushNotification(this.lastBidPlayer.id, new AuctionHouseBuyerNotification(this));
            if (this.tradeOwner != null) {
                NotificationSaveData.PushNotification(this.tradeOwner.id, new AuctionHouseSellerNotification(this));
            }
        } else if (this.tradeOwner != null) {
            AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner);
            List<ItemStack> items = event.getItems();
            for (ItemStack item : items) {
                sellerStorage.giveItem(item);
            }
            NotificationSaveData.PushNotification(this.tradeOwner.id, new AuctionHouseSellerNobidNotification(this));
        }
    }

    public void CancelTrade(AuctionHouseTrader trader, boolean giveToPlayer, Player player) {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        if (this.lastBidPlayer != null) {
            AuctionPlayerStorage buyerStorage = trader.getStorage(this.lastBidPlayer);
            buyerStorage.giveMoney(this.lastBidAmount);
            NotificationSaveData.PushNotification(this.lastBidPlayer.id, new AuctionHouseCancelNotification(this));
        }
        if (giveToPlayer) {
            for (ItemStack stack : this.auctionItems) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            }
        } else if (this.tradeOwner != null) {
            AuctionPlayerStorage sellerStorage = trader.getStorage(this.tradeOwner);
            for (ItemStack stack : this.auctionItems) {
                sellerStorage.giveItem(stack);
            }
        }
        AuctionHouseEvent.AuctionEvent.CancelAuctionEvent event = new AuctionHouseEvent.AuctionEvent.CancelAuctionEvent(trader, this, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag itemList = new ListTag();
        for (ItemStack auctionItem : this.auctionItems) {
            itemList.add((Object)auctionItem.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("SellItems", (Tag)itemList);
        compound.m_128365_("LastBid", (Tag)this.lastBidAmount.save());
        if (this.lastBidPlayer != null) {
            compound.m_128365_("LastBidPlayer", (Tag)this.lastBidPlayer.save());
        }
        compound.m_128365_("MinBid", (Tag)this.minBidDifference.save());
        compound.m_128356_("StartTime", this.startTime);
        compound.m_128356_("Duration", this.duration);
        if (this.tradeOwner != null) {
            compound.m_128365_("TradeOwner", (Tag)this.tradeOwner.save());
        }
        compound.m_128379_("Cancelled", this.cancelled);
        if (!this.persistentID.isBlank()) {
            compound.m_128359_("PersistentID", this.persistentID);
        }
        return compound;
    }

    public JsonObject saveToJson(JsonObject json) {
        for (int i = 0; i < this.auctionItems.size(); ++i) {
            json.add("Item" + (i + 1), (JsonElement)FileUtil.convertItemStack(this.auctionItems.get(i)));
        }
        json.addProperty("Duration", (Number)this.duration);
        json.add("StartingBid", (JsonElement)this.lastBidAmount.toJson());
        json.add("MinimumBid", (JsonElement)this.minBidDifference.toJson());
        return json;
    }

    @Override
    public void loadFromNBT(CompoundTag compound) {
        ListTag itemList = compound.m_128437_("SellItems", 10);
        this.auctionItems.clear();
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
            if (stack.m_41619_()) continue;
            this.auctionItems.add(stack);
        }
        this.lastBidAmount = CoinValue.safeLoad(compound, "LastBid");
        this.lastBidPlayer = compound.m_128441_("LastBidPlayer") ? PlayerReference.load(compound.m_128469_("LastBidPlayer")) : null;
        this.minBidDifference = CoinValue.safeLoad(compound, "MinBid");
        this.startTime = compound.m_128454_("StartTime");
        this.duration = compound.m_128454_("Duration");
        if (compound.m_128425_("TradeOwner", 10)) {
            this.tradeOwner = PlayerReference.load(compound.m_128469_("TradeOwner"));
        }
        this.cancelled = compound.m_128471_("Cancelled");
        if (compound.m_128425_("PersistentID", 8)) {
            this.persistentID = compound.m_128461_("PersistentID");
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRenderManager<?> getButtonRenderer() {
        return new AuctionTradeButtonRenderer(this);
    }

    @Override
    public void OnInputDisplayInteraction(@Nonnull BasicTradeEditTab tab, Consumer<LazyPacketData.Builder> clientHandler, int index, int button, @Nonnull ItemStack heldItem) {
        this.openCancelAuctionTab(tab);
    }

    @Override
    public void OnOutputDisplayInteraction(@Nonnull BasicTradeEditTab tab, Consumer<LazyPacketData.Builder> clientHandler, int index, int button, @Nonnull ItemStack heldItem) {
        this.openCancelAuctionTab(tab);
    }

    @Override
    public void OnInteraction(@Nonnull BasicTradeEditTab tab, Consumer<LazyPacketData.Builder> clientHandler, int mouseX, int mouseY, int button, @Nonnull ItemStack heldItem) {
        this.openCancelAuctionTab(tab);
    }

    private void openCancelAuctionTab(BasicTradeEditTab tab) {
        TraderData traderData = tab.menu.getTrader();
        if (traderData instanceof AuctionHouseTrader) {
            AuctionHouseTrader ah = (AuctionHouseTrader)traderData;
            int tradeIndex = ah.getTradeIndex(this);
            if (tradeIndex < 0) {
                return;
            }
            tab.sendOpenTabMessage(2, LazyPacketData.simpleInt("TradeIndex", tradeIndex));
        }
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        return TradeData.TradeDirection.NONE;
    }

    @Override
    public TradeComparisonResult compare(TradeData otherTrade) {
        return new TradeComparisonResult();
    }

    @Override
    public boolean AcceptableDifferences(TradeComparisonResult result) {
        return false;
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeComparisonResult differences) {
        return new ArrayList<Component>();
    }
}

