/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.client;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyScreenHelper;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public class AuctionTradeButtonRenderer
extends TradeRenderManager<AuctionTradeData> {
    public AuctionTradeButtonRenderer(AuctionTradeData trade) {
        super(trade);
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 94;
    }

    @Override
    public LazyOptional<ScreenPosition> arrowPosition(TradeContext context) {
        return ScreenPosition.ofOptional(36, 1);
    }

    @Override
    public TradeButton.DisplayData inputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(1, 1, 34, 16);
    }

    @Override
    public List<TradeButton.DisplayEntry> getInputDisplays(TradeContext context) {
        return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of(((AuctionTradeData)this.trade).getLastBidAmount(), this.getBidInfo(), true)});
    }

    private List<Component> getBidInfo() {
        ArrayList<Component> bidInfo = new ArrayList<Component>();
        if (((AuctionTradeData)this.trade).getLastBidPlayer() == null) {
            bidInfo.add((Component)EasyText.translatable("tooltip.lightmanscurrency.auction.nobidder", new Object[0]));
            bidInfo.add((Component)EasyText.translatable("tooltip.lightmanscurrency.auction.minbid", ((AuctionTradeData)this.trade).getLastBidAmount().getString()));
        } else {
            bidInfo.add((Component)EasyText.translatable("tooltip.lightmanscurrency.auction.lastbidder", ((AuctionTradeData)this.trade).getLastBidPlayer().getName(true)));
            bidInfo.add((Component)EasyText.translatable("tooltip.lightmanscurrency.auction.currentbid", ((AuctionTradeData)this.trade).getLastBidAmount().getString()));
            bidInfo.add((Component)EasyText.translatable("tooltip.lightmanscurrency.auction.minbid", ((AuctionTradeData)this.trade).getMinNextBid().getString()));
        }
        return bidInfo;
    }

    @Override
    public TradeButton.DisplayData outputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(58, 1, 34, 16);
    }

    @Override
    public List<TradeButton.DisplayEntry> getOutputDisplays(TradeContext context) {
        ArrayList<TradeButton.DisplayEntry> entries = new ArrayList<TradeButton.DisplayEntry>();
        for (ItemStack item : ((AuctionTradeData)this.trade).getAuctionItems()) {
            if (item.m_41619_()) continue;
            entries.add(TradeButton.DisplayEntry.of(item, item.m_41613_(), EasyScreenHelper.getTooltipFromItem(item)));
        }
        return entries;
    }

    @Override
    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        alerts.clear();
    }

    @Override
    public void renderAdditional(EasyWidget button, EasyGuiGraphics gui, TradeContext context) {
        TimeUtil.TimeData time = new TimeUtil.TimeData(((AuctionTradeData)this.trade).getRemainingTime(TimeUtil.getCurrentTime()));
        TextRenderUtil.drawCenteredText(gui, time.getShortString(1), button.m_5711_() / 2, button.m_93694_() - 9, this.getTextColor(time));
    }

    @Override
    public List<Component> getAdditionalTooltips(TradeContext context, int mouseX, int mouseY) {
        TimeUtil.TimeData time = new TimeUtil.TimeData(((AuctionTradeData)this.trade).getRemainingTime(TimeUtil.getCurrentTime()));
        return Lists.newArrayList((Object[])new Component[]{EasyText.translatable("gui.lightmanscurrency.auction.time_remaining", EasyText.literal(time.getString()).m_130938_(s -> s.m_178520_(this.getTextColor(time))))});
    }

    private int getTextColor(TimeUtil.TimeData remainingTime) {
        if (remainingTime.miliseconds < 3600000L) {
            if (remainingTime.miliseconds < 300000L) {
                return 0xFF0000;
            }
            return 0xFFFF00;
        }
        return 65280;
    }
}

