/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCTags;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.ticket.TicketSlot;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TicketKioskRestriction
extends ItemTradeRestriction {
    public static TicketKioskRestriction INSTANCE = new TicketKioskRestriction();

    private TicketKioskRestriction() {
    }

    @Override
    public ItemStack modifySellItem(ItemStack sellItem, String customName, ItemTradeData trade) {
        if (sellItem.m_41720_() instanceof TicketItem && !customName.isBlank()) {
            sellItem.m_41714_((Component)EasyText.literal(customName));
        }
        return sellItem;
    }

    @Override
    public boolean allowSellItem(ItemStack itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return true;
        }
        return InventoryUtil.ItemHasTag(itemStack, LCTags.Items.TICKET_MATERIAL) && itemStack.m_41720_() != ModItems.TICKET.get();
    }

    @Override
    public ItemStack filterSellItem(ItemStack itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return TicketItem.CreateTicket(itemStack);
        }
        if (InventoryUtil.ItemHasTag(itemStack, LCTags.Items.TICKET_MATERIAL) && itemStack.m_41720_() != ModItems.TICKET.get()) {
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean allowItemSelectItem(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return InventoryUtil.ItemHasTag(itemStack, LCTags.Items.TICKET_MATERIAL) && item != ModItems.TICKET.get() && item != ModItems.TICKET_MASTER.get();
    }

    @Override
    public boolean allowExtraItemInStorage(ItemStack itemStack) {
        return InventoryUtil.ItemHasTag(itemStack, LCTags.Items.TICKET_MATERIAL);
    }

    @Override
    public int getSaleStock(TraderItemStorage traderStorage, ItemTradeData trade) {
        int ticketCount = 0;
        boolean foundTicket = false;
        int minStock = Integer.MAX_VALUE;
        for (ItemStack sellItem : Lists.newArrayList((Object[])new ItemStack[]{trade.getSellItem(0), trade.getSellItem(1)})) {
            ticketCount += sellItem.m_41613_();
            if (sellItem.m_41720_() == ModItems.TICKET.get()) {
                foundTicket = true;
                continue;
            }
            minStock = Math.min(this.getItemStock(sellItem, traderStorage), minStock);
        }
        if (foundTicket && ticketCount > 0) {
            minStock = Math.min(this.getTicketStock(ticketCount, traderStorage), minStock);
        }
        return minStock;
    }

    protected final int getTicketStock(int ticketCount, TraderItemStorage traderStorage) {
        return traderStorage.getItemTagCount(LCTags.Items.TICKET_MATERIAL, (Item)ModItems.TICKET_MASTER.get()) / ticketCount;
    }

    @Override
    public void removeItemsFromStorage(TraderItemStorage traderStorage, List<ItemStack> soldItems) {
        ArrayList<ItemStack> tickets = new ArrayList<ItemStack>();
        ArrayList<ItemStack> ignoreIfPossible = new ArrayList<ItemStack>();
        for (ItemStack sellItem : soldItems) {
            if (sellItem.m_41720_() == ModItems.TICKET.get()) {
                tickets.add(sellItem);
                continue;
            }
            this.removeFromStorage(sellItem, traderStorage);
            ignoreIfPossible.add(sellItem);
        }
        int printCount = 0;
        for (ItemStack ticketStack : tickets) {
            printCount += ticketStack.m_41613_() - traderStorage.removeItem(ticketStack).m_41613_();
        }
        if (printCount > 0) {
            traderStorage.removeItemTagCount(LCTags.Items.TICKET_MATERIAL, printCount, ignoreIfPossible, (Item)ModItems.TICKET_MASTER.get());
        }
    }

    @Override
    public boolean alwaysEnforceNBT(int tradeSlot) {
        return tradeSlot < 2;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        return Pair.of((Object)InventoryMenu.f_39692_, (Object)TicketSlot.EMPTY_TICKET_SLOT);
    }
}

