/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.client;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.client.TradeRenderManager;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public class PaygateTradeButtonRenderer
extends TradeRenderManager<PaygateTradeData> {
    public PaygateTradeButtonRenderer(PaygateTradeData trade) {
        super(trade);
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 94;
    }

    @Override
    public LazyOptional<ScreenPosition> arrowPosition(TradeContext context) {
        return ScreenPosition.ofOptional(36, 1);
    }

    @Override
    public TradeButton.DisplayData inputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(1, 1, 34, 16);
    }

    @Override
    public List<TradeButton.DisplayEntry> getInputDisplays(TradeContext context) {
        if (((PaygateTradeData)this.trade).isTicketTrade()) {
            return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of(TicketItem.CreateTicket(((PaygateTradeData)this.trade).getTicketID(), ((PaygateTradeData)this.trade).getTicketColor()), 1, (List<Component>)Lists.newArrayList((Object[])new Component[]{EasyText.translatable("tooltip.lightmanscurrency.ticket.id", ((PaygateTradeData)this.trade).getTicketID())}))});
        }
        return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of(((PaygateTradeData)this.trade).getCost(context), context.isStorageMode ? Lists.newArrayList((Object[])new Component[]{EasyText.translatable("tooltip.lightmanscurrency.trader.price_edit", new Object[0])}) : null)});
    }

    @Override
    public TradeButton.DisplayData outputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(58, 1, 34, 16);
    }

    @Override
    public List<TradeButton.DisplayEntry> getOutputDisplays(TradeContext context) {
        return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of((Component)PaygateTradeData.formatDurationDisplay(((PaygateTradeData)this.trade).getDuration()), TextRenderUtil.TextFormatting.create(), (List<Component>)Lists.newArrayList((Object[])new Component[]{PaygateTradeData.formatDuration(((PaygateTradeData)this.trade).getDuration())}))});
    }

    @Override
    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        TraderData traderData;
        if (context.hasTrader() && (traderData = context.getTrader()) instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            if (paygate.isActive()) {
                alerts.add(AlertData.warn(EasyText.translatable("tooltip.lightmanscurrency.paygate.active", new Object[0])));
            }
            if (!((PaygateTradeData)this.trade).canAfford(context)) {
                alerts.add(AlertData.warn(EasyText.translatable("tooltip.lightmanscurrency.cannotafford", new Object[0])));
            }
        }
    }
}

