/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.permissions.options;

import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.MutableComponent;

public abstract class PermissionOption {
    public final String permission;
    protected SettingsSubTab tab;

    protected PermissionOption(String permission) {
        this.permission = permission;
    }

    public MutableComponent widgetName() {
        return EasyText.translatable("permission." + this.permission, new Object[0]);
    }

    protected final boolean hasPermission() {
        return this.permissionValue() > 0;
    }

    protected final int permissionValue() {
        if (this.tab.menu.getTrader() == null) {
            return 0;
        }
        return this.tab.menu.getTrader().getAllyPermissionLevel(this.permission);
    }

    public final void setValue(boolean newValue) {
        this.setValue(newValue ? 1 : 0);
    }

    public final void setValue(int newValue) {
        if (this.tab.menu.getTrader() == null) {
            return;
        }
        this.tab.menu.getTrader().setAllyPermissionLevel(this.tab.menu.player, this.permission, newValue);
        this.tab.sendMessage(LazyPacketData.builder().setString("ChangeAllyPermissions", this.permission).setInt("NewLevel", newValue));
    }

    public final void initWidgets(SettingsSubTab tab, int x, int y, Consumer<Object> addWidgets) {
        this.tab = tab;
        this.createWidget(x, y, addWidgets);
    }

    protected abstract void createWidget(int var1, int var2, Consumer<Object> var3);

    public void tick() {
    }

    public void render(@Nonnull EasyGuiGraphics gui) {
    }

    public abstract int widgetWidth();
}

