/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.PlayerTradeLimitTab;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerTradeLimit
extends TradeRule {
    public static final ResourceLocation OLD_TYPE = new ResourceLocation("lightmanscurrency", "tradelimit");
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "player_trade_limit");
    private int limit = 1;
    private long timeLimit = 0L;
    Map<UUID, List<Long>> memory = new HashMap<UUID, List<Long>>();

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        this.limit = newLimit;
    }

    private boolean enforceTimeLimit() {
        return this.timeLimit > 0L;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(long timeLimit) {
        this.timeLimit = timeLimit;
    }

    public void resetMemory() {
        this.memory.clear();
    }

    public PlayerTradeLimit() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        int tradeCount = this.getTradeCount(event.getPlayerReference().id);
        if (tradeCount >= this.limit) {
            if (this.enforceTimeLimit()) {
                event.addDenial(EasyText.translatable("traderule.lightmanscurrency.tradelimit.denial.timed", tradeCount, new TimeUtil.TimeData(this.getTimeLimit()).getString()));
            } else {
                event.addDenial(EasyText.translatable("traderule.lightmanscurrency.tradelimit.denial", tradeCount));
            }
            event.addDenial(EasyText.translatable("traderule.lightmanscurrency.tradelimit.denial.limit", this.limit));
        } else if (this.enforceTimeLimit()) {
            event.addHelpful(EasyText.translatable("traderule.lightmanscurrency.tradelimit.info.timed", tradeCount, this.limit, new TimeUtil.TimeData(this.getTimeLimit()).getString()));
        } else {
            event.addHelpful(EasyText.translatable("traderule.lightmanscurrency.tradelimit.info", tradeCount, this.limit));
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.addEvent(event.getPlayerReference().id, TimeUtil.getCurrentTime());
        this.clearExpiredData();
        event.markDirty();
    }

    private void addEvent(UUID player, Long time) {
        List<Long> eventTimes = new ArrayList<Long>();
        if (this.memory.containsKey(player)) {
            eventTimes = this.memory.get(player);
        }
        eventTimes.add(time);
        this.memory.put(player, eventTimes);
    }

    private void clearExpiredData() {
        if (!this.enforceTimeLimit()) {
            return;
        }
        ArrayList emptyEntries = new ArrayList();
        this.memory.forEach((id, eventTimes) -> {
            for (int i = 0; i < eventTimes.size(); ++i) {
                if (TimeUtil.compareTime(this.timeLimit, (Long)eventTimes.get(i))) continue;
                eventTimes.remove(i);
                --i;
            }
            if (eventTimes.size() == 0) {
                emptyEntries.add(id);
            }
        });
        emptyEntries.forEach(id -> this.memory.remove(id));
    }

    private int getTradeCount(UUID playerID) {
        int count = 0;
        if (this.memory.containsKey(playerID)) {
            List<Long> eventTimes = this.memory.get(playerID);
            if (!this.enforceTimeLimit()) {
                return eventTimes.size();
            }
            for (Long eventTime : eventTimes) {
                if (!TimeUtil.compareTime(this.timeLimit, eventTime)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128405_("Limit", this.limit);
        ListTag memoryList = new ListTag();
        this.memory.forEach((id, eventTimes) -> {
            CompoundTag thisMemory = new CompoundTag();
            thisMemory.m_128362_("id", id);
            thisMemory.m_128428_("times", eventTimes);
            memoryList.add((Object)thisMemory);
        });
        compound.m_128365_("Memory", (Tag)memoryList);
        compound.m_128356_("ForgetTime", this.timeLimit);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("Limit", (Number)this.limit);
        if (this.enforceTimeLimit()) {
            json.addProperty("ForgetTime", (Number)this.timeLimit);
        }
        return json;
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        if (compound.m_128425_("Limit", 3)) {
            this.limit = compound.m_128451_("Limit");
        }
        if (compound.m_128425_("Memory", 9)) {
            this.memory.clear();
            ListTag memoryList = compound.m_128437_("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundTag thisMemory = memoryList.m_128728_(i);
                UUID id = null;
                ArrayList<Long> eventTimes = new ArrayList<Long>();
                if (thisMemory.m_128441_("id")) {
                    id = thisMemory.m_128342_("id");
                }
                if (thisMemory.m_128425_("count", 3)) {
                    int count = thisMemory.m_128451_("count");
                    for (int z = 0; z < count; ++z) {
                        eventTimes.add(0L);
                    }
                }
                if (thisMemory.m_128425_("times", 12)) {
                    for (long time : thisMemory.m_128467_("times")) {
                        eventTimes.add(time);
                    }
                }
                this.memory.put(id, eventTimes);
            }
        }
        if (compound.m_128425_("ForgetTime", 4)) {
            this.timeLimit = compound.m_128454_("ForgetTime");
        }
    }

    @Override
    public void handleUpdateMessage(CompoundTag updateInfo) {
        if (updateInfo.m_128441_("Limit")) {
            this.limit = updateInfo.m_128451_("Limit");
        } else if (updateInfo.m_128441_("TimeLimit")) {
            this.timeLimit = updateInfo.m_128454_("TimeLimit");
        } else if (updateInfo.m_128441_("ClearMemory")) {
            this.resetMemory();
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        CompoundTag data = new CompoundTag();
        ListTag memoryList = new ListTag();
        this.memory.forEach((id, eventTimes) -> {
            CompoundTag thisMemory = new CompoundTag();
            thisMemory.m_128362_("id", id);
            thisMemory.m_128428_("times", eventTimes);
            memoryList.add((Object)thisMemory);
        });
        data.m_128365_("Memory", (Tag)memoryList);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
        if (data.m_128425_("Memory", 9)) {
            this.memory.clear();
            ListTag memoryList = data.m_128437_("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundTag thisMemory = memoryList.m_128728_(i);
                UUID id = null;
                ArrayList<Long> eventTimes = new ArrayList<Long>();
                if (thisMemory.m_128441_("id")) {
                    id = thisMemory.m_128342_("id");
                }
                if (thisMemory.m_128425_("count", 3)) {
                    int count = thisMemory.m_128451_("count");
                    for (int z = 0; z < count; ++z) {
                        eventTimes.add(0L);
                    }
                }
                if (thisMemory.m_128425_("times", 12)) {
                    for (long time : thisMemory.m_128467_("times")) {
                        eventTimes.add(time);
                    }
                }
                this.memory.put(id, eventTimes);
            }
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Limit")) {
            this.limit = json.get("Limit").getAsInt();
        }
        if (json.has("ForgetTime")) {
            this.timeLimit = json.get("ForgetTime").getAsLong();
        }
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new PlayerTradeLimitTab(parent);
    }
}

