/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.TimedSaleTab;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.PriceTweakingTradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TimedSale
extends PriceTweakingTradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "timed_sale");
    long startTime = 0L;
    long duration = 0L;
    int discount = 10;

    public void setStartTime(long time) {
        this.startTime = time;
    }

    public boolean timerActive() {
        return this.startTime != 0L;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = MathUtil.clamp(duration, 1000L, Long.MAX_VALUE);
    }

    public int getDiscount() {
        return this.discount;
    }

    public void setDiscount(int discount) {
        this.discount = MathUtil.clamp(discount, 1, 100);
    }

    public TimedSale() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.timerActive() && TimeUtil.compareTime(this.duration, this.startTime)) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.addHelpful(EasyText.translatable("traderule.lightmanscurrency.timed_sale.info.sale", this.discount, this.getTimeRemaining().getString()));
                    break;
                }
                case PURCHASE: {
                    event.addHelpful(EasyText.translatable("traderule.lightmanscurrency.timed_sale.info.purchase", this.discount, this.getTimeRemaining().getString()));
                    break;
                }
            }
        }
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.timerActive() && TimeUtil.compareTime(this.duration, this.startTime)) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.giveDiscount(this.discount);
                    break;
                }
                case PURCHASE: {
                    event.hikePrice(this.discount);
                    break;
                }
            }
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        if (this.confirmStillActive()) {
            event.markDirty();
        }
    }

    private boolean confirmStillActive() {
        if (!this.timerActive()) {
            return false;
        }
        if (!TimeUtil.compareTime(this.duration, this.startTime)) {
            this.startTime = 0L;
            return true;
        }
        return false;
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128356_("startTime", this.startTime);
        compound.m_128356_("duration", this.duration);
        compound.m_128405_("discount", this.discount);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("duration", (Number)this.duration);
        json.addProperty("discount", (Number)this.discount);
        return json;
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        if (compound.m_128425_("startTime", 4)) {
            this.startTime = compound.m_128454_("startTime");
        }
        if (compound.m_128425_("duration", 4)) {
            this.duration = compound.m_128454_("duration");
        }
        if (compound.m_128425_("discount", 3)) {
            this.discount = compound.m_128451_("discount");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("duration")) {
            this.duration = json.get("duration").getAsLong();
        }
        if (json.has("discount")) {
            this.discount = MathUtil.clamp(this.discount, 0, 100);
        }
    }

    @Override
    public void handleUpdateMessage(CompoundTag updateInfo) {
        if (updateInfo.m_128441_("Discount")) {
            this.discount = updateInfo.m_128451_("Discount");
        } else if (updateInfo.m_128441_("Duration")) {
            this.duration = updateInfo.m_128454_("Duration");
        } else if (updateInfo.m_128441_("StartSale")) {
            if (this.timerActive() == updateInfo.m_128471_("StartSale")) {
                return;
            }
            this.startTime = this.timerActive() ? 0L : TimeUtil.getCurrentTime();
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        CompoundTag compound = new CompoundTag();
        compound.m_128356_("startTime", this.startTime);
        return compound;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
        if (data.m_128425_("startTime", 4)) {
            this.startTime = data.m_128454_("startTime");
        }
    }

    public TimeUtil.TimeData getTimeRemaining() {
        if (!this.timerActive()) {
            return new TimeUtil.TimeData(0L);
        }
        return new TimeUtil.TimeData(this.startTime + this.duration - TimeUtil.getCurrentTime());
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new TimedSaleTab(parent);
    }
}

