/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.TradeLimitTab;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TradeLimit
extends TradeRule {
    public static final ResourceLocation OLD_TYPE = new ResourceLocation("lightmanscurrency", "tradelimit2");
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "trade_limit");
    private int limit = 1;
    int count = 0;

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        this.limit = newLimit;
    }

    public void resetCount() {
        this.count = 0;
    }

    public TradeLimit() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.count >= this.limit) {
            event.addDenial(EasyText.translatable("traderule.lightmanscurrency.tradelimit2.denial", this.count));
            event.addDenial(EasyText.translatable("traderule.lightmanscurrency.tradelimit.denial.limit", this.limit));
        } else {
            event.addHelpful(EasyText.translatable("traderule.lightmanscurrency.tradelimit2.info", this.count, this.limit));
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        ++this.count;
        event.markDirty();
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128405_("Limit", this.limit);
        compound.m_128405_("Count", this.count);
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        json.addProperty("Limit", (Number)this.limit);
        return json;
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        if (compound.m_128425_("Limit", 3)) {
            this.limit = compound.m_128451_("Limit");
        }
        if (compound.m_128425_("Count", 3)) {
            this.count = compound.m_128451_("Count");
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
        if (json.has("Limit")) {
            this.limit = json.get("Limit").getAsInt();
        }
    }

    @Override
    public void handleUpdateMessage(CompoundTag updateInfo) {
        if (updateInfo.m_128441_("Limit")) {
            this.limit = updateInfo.m_128451_("Limit");
        } else if (updateInfo.m_128441_("ClearMemory")) {
            this.count = 0;
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        CompoundTag data = new CompoundTag();
        data.m_128405_("Count", this.count);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
        if (data.m_128425_("Count", 3)) {
            this.count = data.m_128451_("Count");
        }
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new TradeLimitTab(parent);
    }
}

