/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.tradedata;

import io.github.lightman314.lightmanscurrency.common.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.taxes.TaxEntry;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.comparison.TradeComparisonResult;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class TradeData
implements ITradeRuleHost {
    public static final String DEFAULT_KEY = "Trades";
    protected CoinValue cost = CoinValue.EMPTY;
    List<TradeRule> rules = new ArrayList<TradeRule>();
    private final boolean validateRules;

    public abstract TradeDirection getTradeDirection();

    public boolean validCost() {
        return this.getCost().isFree() || this.getCost().getValueNumber() > 0L;
    }

    public boolean isValid() {
        return this.validCost();
    }

    public CoinValue getCost() {
        return this.cost;
    }

    public CoinValue getCost(TradeContext context) {
        if (context.hasTrader() && context.hasPlayerReference()) {
            return context.getTrader().runTradeCostEvent(context.getPlayerReference(), this).getCostResult();
        }
        return this.getCost();
    }

    public CoinValue getCostWithTaxes(TraderData trader) {
        CoinValue cost = this.cost;
        long taxAmount = 0L;
        for (TaxEntry entry : trader.getApplicableTaxes()) {
            taxAmount += cost.percentageOfValue(entry.getTaxRate()).getValueNumber();
        }
        return cost.plusValue(CoinValue.fromNumber(taxAmount));
    }

    public CoinValue getCostWithTaxes(TradeContext context) {
        CoinValue cost = this.getCost(context);
        if (context.hasTrader()) {
            TraderData trader = context.getTrader();
            long taxAmount = 0L;
            for (TaxEntry entry : trader.getApplicableTaxes()) {
                taxAmount += cost.percentageOfValue(entry.getTaxRate()).getValueNumber();
            }
            return cost.plusValue(CoinValue.fromNumber(taxAmount));
        }
        return cost;
    }

    public void setCost(CoinValue value) {
        this.cost = value;
    }

    public final int stockCountOfCost(TraderData trader) {
        if (this.cost.isFree()) {
            return 1;
        }
        if (this.cost.getValueNumber() == 0L) {
            return 0;
        }
        long coinValue = trader.getStoredMoney().getValueNumber();
        long price = this.getCostWithTaxes(trader).getValueNumber();
        return (int)(coinValue / price);
    }

    public final int stockCountOfCost(TradeContext context) {
        if (!context.hasTrader()) {
            return 0;
        }
        TraderData trader = context.getTrader();
        if (this.cost.isFree()) {
            return 1;
        }
        if (this.cost.getValueNumber() == 0L) {
            return 0;
        }
        long coinValue = trader.getStoredMoney().getValueNumber();
        long price = this.getCostWithTaxes(context).getValueNumber();
        return (int)MathUtil.SafeDivide(coinValue, price, 1L);
    }

    protected TradeData(boolean validateRules) {
        this.validateRules = validateRules;
        if (this.validateRules) {
            TradeRule.ValidateTradeRuleList(this.rules, this);
        }
    }

    public CompoundTag getAsNBT() {
        CompoundTag tradeNBT = new CompoundTag();
        tradeNBT.m_128365_("Price", (Tag)this.cost.save());
        TradeRule.saveRules(tradeNBT, this.rules, "RuleData");
        return tradeNBT;
    }

    protected void loadFromNBT(CompoundTag nbt) {
        this.cost = CoinValue.safeLoad(nbt, "Price");
        if (nbt.m_128441_("IsFree") && nbt.m_128471_("IsFree")) {
            this.cost = CoinValue.FREE;
        }
        this.rules.clear();
        if (nbt.m_128441_("TradeRules")) {
            this.rules = TradeRule.loadRules(nbt, "TradeRules", this);
            for (TradeRule r : this.rules) {
                r.setActive(true);
            }
        } else {
            this.rules = TradeRule.loadRules(nbt, "RuleData", this);
        }
        if (this.validateRules) {
            TradeRule.ValidateTradeRuleList(this.rules, this);
        }
    }

    @Override
    public final boolean isTrader() {
        return false;
    }

    @Override
    public final boolean isTrade() {
        return true;
    }

    @Override
    public boolean allowTradeRule(@Nonnull TradeRule rule) {
        return true;
    }

    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.beforeTrade(event);
        }
    }

    public void tradeCost(TradeEvent.TradeCostEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.tradeCost(event);
        }
    }

    public void afterTrade(TradeEvent.PostTradeEvent event) {
        for (TradeRule rule : this.rules) {
            if (!rule.isActive()) continue;
            rule.afterTrade(event);
        }
    }

    @Override
    @Nonnull
    public List<TradeRule> getRules() {
        return new ArrayList<TradeRule>(this.rules);
    }

    @Override
    public void markTradeRulesDirty() {
    }

    public void setRules(List<TradeRule> rules) {
        this.rules = rules;
    }

    public abstract TradeComparisonResult compare(TradeData var1);

    public abstract boolean AcceptableDifferences(TradeComparisonResult var1);

    public abstract List<Component> GetDifferenceWarnings(TradeComparisonResult var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract TradeRenderManager<?> getButtonRenderer();

    @Deprecated(since="2.1.2.4")
    public void onInputDisplayInteraction(@Nonnull BasicTradeEditTab tab, @Nullable Consumer<CompoundTag> clientHandler, int index, int button, @Nonnull ItemStack heldItem) {
    }

    public abstract void OnInputDisplayInteraction(@Nonnull BasicTradeEditTab var1, @Nullable Consumer<LazyPacketData.Builder> var2, int var3, int var4, @Nonnull ItemStack var5);

    @Deprecated(since="2.1.2.4")
    public void onOutputDisplayInteraction(@Nonnull BasicTradeEditTab tab, @Nullable Consumer<CompoundTag> clientHandler, int index, int button, @Nonnull ItemStack heldItem) {
    }

    public abstract void OnOutputDisplayInteraction(@Nonnull BasicTradeEditTab var1, @Nullable Consumer<LazyPacketData.Builder> var2, int var3, int var4, @Nonnull ItemStack var5);

    @Deprecated(since="2.1.2.4")
    public void onInteraction(@Nonnull BasicTradeEditTab tab, @Nullable Consumer<CompoundTag> clientHandler, int mouseX, int mouseY, int button, @Nonnull ItemStack heldItem) {
    }

    public abstract void OnInteraction(@Nonnull BasicTradeEditTab var1, @Nullable Consumer<LazyPacketData.Builder> var2, int var3, int var4, int var5, @Nonnull ItemStack var6);

    @NotNull
    public final List<Integer> getRelevantInventorySlots(TradeContext context, NonNullList<Slot> slots) {
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.collectRelevantInventorySlots(context, slots, results);
        return results;
    }

    protected void collectRelevantInventorySlots(TradeContext context, NonNullList<Slot> slots, List<Integer> results) {
    }

    public static enum TradeDirection {
        SALE(0),
        PURCHASE(1),
        NONE(-1);

        public final int index;

        private TradeDirection(int index) {
            this.index = index;
        }

        public static TradeDirection fromIndex(int index) {
            for (TradeDirection d : TradeDirection.values()) {
                if (d.index != index) continue;
                return d;
            }
            return SALE;
        }
    }
}

