/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.tradedata.comparison;

import io.github.lightman314.lightmanscurrency.common.traders.tradedata.comparison.ProductComparisonResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TradeComparisonResult {
    private boolean compatible = false;
    private final List<ProductComparisonResult> tradeProductResults = new ArrayList<ProductComparisonResult>();
    private long priceChange = 0L;
    private boolean tradeTypeMatches = true;

    public boolean isCompatible() {
        return this.compatible;
    }

    public boolean ProductMatches() {
        for (ProductComparisonResult result : this.tradeProductResults) {
            if (result.Identical()) continue;
            return false;
        }
        return true;
    }

    public ProductComparisonResult getProductResult(int index) {
        if (index < 0 || index >= this.tradeProductResults.size()) {
            return null;
        }
        return this.tradeProductResults.get(index);
    }

    public int getProductResultCount() {
        return this.tradeProductResults.size();
    }

    public boolean PriceMatches() {
        return this.priceChange == 0L;
    }

    public long priceDifference() {
        return this.priceChange;
    }

    public boolean isPriceCheaper() {
        return this.priceChange > 0L;
    }

    public boolean isPriceExpensive() {
        return this.priceChange < 0L;
    }

    public boolean TypeMatches() {
        return this.tradeTypeMatches;
    }

    public boolean Identical() {
        return this.compatible && this.ProductMatches() && this.PriceMatches() && this.TypeMatches();
    }

    public void addProductResult(ProductComparisonResult result) {
        this.tradeProductResults.add(result);
    }

    public void addProductResults(Collection<? extends ProductComparisonResult> results) {
        this.tradeProductResults.addAll(results);
    }

    public void addProductResult(boolean sameProduct, boolean sameNBT, int quantityDifference) {
        this.tradeProductResults.add(new ProductComparisonResult(sameProduct, sameNBT, quantityDifference));
    }

    public void setPriceResult(long priceChange) {
        this.priceChange = priceChange;
    }

    public void setTypeResult(boolean typeMatches) {
        this.tradeTypeMatches = typeMatches;
    }

    public void setCompatible() {
        this.compatible = true;
    }
}

