/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.SpeedUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.ItemCapacityUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestExchangeUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestMagnetUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestSecurityUpgrade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Event;

public abstract class UpgradeType {
    private static final Map<ResourceLocation, UpgradeType> UPGRADE_TYPE_REGISTRY = new HashMap<ResourceLocation, UpgradeType>();
    public static final ItemCapacityUpgrade ITEM_CAPACITY = UpgradeType.register(new ResourceLocation("lightmanscurrency", "item_capacity"), new ItemCapacityUpgrade());
    public static final SpeedUpgrade SPEED = UpgradeType.register(new ResourceLocation("lightmanscurrency", "speed"), new SpeedUpgrade());
    public static final Simple NETWORK = UpgradeType.register(new ResourceLocation("lightmanscurrency", "trader_network"), new Simple(new Component[]{EasyText.translatable("tooltip.lightmanscurrency.upgrade.network", new Object[0])}));
    public static final Simple HOPPER = UpgradeType.register(new ResourceLocation("lightmanscurrency", "hopper"), new Simple(new Component[]{EasyText.translatable("tooltip.lightmanscurrency.upgrade.hopper", new Object[0])}));
    public static final CoinChestExchangeUpgrade COIN_CHEST_EXCHANGE = UpgradeType.register(new ResourceLocation("lightmanscurrency", "coin_chest_exchange"), new CoinChestExchangeUpgrade());
    public static final CoinChestMagnetUpgrade COIN_CHEST_MAGNET = UpgradeType.register(new ResourceLocation("lightmanscurrency", "coin_chest_magnet"), new CoinChestMagnetUpgrade());
    public static final CoinChestSecurityUpgrade COIN_CHEST_SECURITY = UpgradeType.register(new ResourceLocation("lightmanscurrency", "coin_chest_security"), new CoinChestSecurityUpgrade());
    private ResourceLocation type;

    protected abstract List<String> getDataTags();

    protected abstract Object defaultTagValue(String var1);

    public List<Component> getTooltip(UpgradeData data) {
        return Lists.newArrayList();
    }

    public final UpgradeData getDefaultData() {
        return new UpgradeData(this);
    }

    public final UpgradeType setRegistryName(ResourceLocation name) {
        this.type = name;
        return this;
    }

    public ResourceLocation getRegistryName() {
        return this.type;
    }

    public Class<UpgradeType> getRegistryType() {
        return UpgradeType.class;
    }

    public boolean clearDataFromStack(CompoundTag itemTag) {
        return false;
    }

    private static <T extends UpgradeType> T register(ResourceLocation type, T upgradeType) {
        UPGRADE_TYPE_REGISTRY.put(type, upgradeType.setRegistryName(type));
        return upgradeType;
    }

    public static boolean hasUpgrade(UpgradeType type, Container upgradeContainer) {
        for (int i = 0; i < upgradeContainer.m_6643_(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = upgradeContainer.m_8020_(i);
            if (!(stack.m_41720_() instanceof UpgradeItem) || (upgradeItem = (UpgradeItem)stack.m_41720_()).getUpgradeType() != type) continue;
            return true;
        }
        return false;
    }

    public static class UpgradeData {
        public static final UpgradeData EMPTY = new UpgradeData();
        private final Map<String, Object> data = new HashMap<String, Object>();

        public Set<String> getKeys() {
            return this.data.keySet();
        }

        public boolean hasKey(String tag) {
            return this.getKeys().contains(tag);
        }

        private UpgradeData() {
        }

        public UpgradeData(UpgradeType upgrade) {
            for (String tag : upgrade.getDataTags()) {
                Object defaultValue = upgrade.defaultTagValue(tag);
                this.data.put(tag, defaultValue);
            }
        }

        public void setValue(String tag, Object value) {
            if (this.data.containsKey(tag)) {
                this.data.put(tag, value);
            }
        }

        public Object getValue(String tag) {
            if (this.data.containsKey(tag)) {
                return this.data.get(tag);
            }
            return null;
        }

        public boolean getBooleanValue(String tag) {
            Object object = this.getValue(tag);
            if (object instanceof Boolean) {
                Boolean b = (Boolean)object;
                return b;
            }
            return false;
        }

        public int getIntValue(String tag) {
            Object object = this.getValue(tag);
            if (object instanceof Integer) {
                Integer i = (Integer)object;
                return i;
            }
            return 0;
        }

        public long getLongValue(String tag) {
            Object object = this.getValue(tag);
            if (object instanceof Long) {
                Long l = (Long)object;
                return l;
            }
            return 0L;
        }

        public float getFloatValue(String tag) {
            Object object = this.getValue(tag);
            if (object instanceof Float) {
                Float f = (Float)object;
                return f.floatValue();
            }
            return 0.0f;
        }

        public String getStringValue(String tag) {
            Object object = this.getValue(tag);
            if (object instanceof String) {
                String s = (String)object;
                return s;
            }
            return "";
        }

        public CompoundTag getCompoundValue(String tag) {
            Object object = this.getValue(tag);
            if (object instanceof CompoundTag) {
                CompoundTag c = (CompoundTag)object;
                return c;
            }
            return new CompoundTag();
        }

        public void read(CompoundTag compound) {
            compound.m_128431_().forEach(key -> {
                if (this.hasKey((String)key)) {
                    if (compound.m_128425_(key, 1)) {
                        this.setValue((String)key, compound.m_128471_(key));
                    } else if (compound.m_128425_(key, 3)) {
                        this.setValue((String)key, compound.m_128451_(key));
                    } else if (compound.m_128425_(key, 4)) {
                        this.setValue((String)key, compound.m_128454_(key));
                    } else if (compound.m_128425_(key, 5)) {
                        this.setValue((String)key, Float.valueOf(compound.m_128457_(key)));
                    } else if (compound.m_128425_(key, 8)) {
                        this.setValue((String)key, compound.m_128461_(key));
                    } else if (compound.m_128425_(key, 10)) {
                        this.setValue((String)key, compound.m_128469_(key));
                    }
                }
            });
        }

        public CompoundTag writeToNBT() {
            return this.writeToNBT(null);
        }

        public CompoundTag writeToNBT(@Nullable UpgradeType source) {
            Map<String, Object> modifiedEntries = source == null ? this.data : UpgradeData.getModifiedEntries(this, source);
            CompoundTag compound = new CompoundTag();
            modifiedEntries.forEach((key, value) -> {
                if (value instanceof Boolean) {
                    compound.m_128379_(key, ((Boolean)value).booleanValue());
                }
                if (value instanceof Integer) {
                    compound.m_128405_(key, ((Integer)value).intValue());
                } else if (value instanceof Float) {
                    compound.m_128350_(key, ((Float)value).floatValue());
                } else if (value instanceof Long) {
                    compound.m_128356_(key, ((Long)value).longValue());
                } else if (value instanceof String) {
                    compound.m_128359_(key, (String)value);
                } else if (value instanceof CompoundTag) {
                    compound.m_128365_(key, (Tag)((CompoundTag)value));
                }
            });
            return compound;
        }

        public static Map<String, Object> getModifiedEntries(UpgradeData queryData, UpgradeType source) {
            HashMap modifiedEntries = Maps.newHashMap();
            source.getDefaultData().data.forEach((key, value) -> {
                if (queryData.data.containsKey(key) && !Objects.equal((Object)queryData.data.get(key), (Object)value)) {
                    modifiedEntries.put(key, value);
                }
            });
            return modifiedEntries;
        }
    }

    public static class Simple
    extends UpgradeType {
        private final List<Component> tooltips;

        public Simple(Component ... tooltips) {
            this.tooltips = Lists.newArrayList((Object[])tooltips);
        }

        @Override
        protected List<String> getDataTags() {
            return new ArrayList<String>();
        }

        @Override
        protected Object defaultTagValue(String tag) {
            return null;
        }

        @Override
        public List<Component> getTooltip(UpgradeData data) {
            return this.tooltips;
        }
    }

    public static class RegisterUpgradeTypeEvent
    extends Event {
        public <T extends UpgradeType> void Register(ResourceLocation type, T upgradeType) {
            UpgradeType.register(type, upgradeType);
        }
    }

    public static interface IUpgradeItem {
        public UpgradeType getUpgradeType();

        public UpgradeData getDefaultUpgradeData();

        default public void onApplied(IUpgradeable target) {
        }
    }

    public static interface IUpgradeable {
        default public boolean allowUpgrade(UpgradeItem item) {
            return this.allowUpgrade(item.getUpgradeType());
        }

        public boolean allowUpgrade(UpgradeType var1);
    }
}

