/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Vector3d;
import io.github.lightman314.lightmanscurrency.common.blockentity.CoinChestBlockEntity;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menus.CoinChestMenu;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.CoinChestUpgradeData;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.coin_chest.TickableCoinChestUpgrade;
import io.github.lightman314.lightmanscurrency.network.packet.LazyPacketData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class CoinChestMagnetUpgrade
extends TickableCoinChestUpgrade {
    public static final String RANGE = "magnet_range";

    @Override
    public void HandleMenuMessage(CoinChestMenu menu, CoinChestUpgradeData data, LazyPacketData message) {
    }

    @Override
    public void addClientTabs(@Nonnull CoinChestUpgradeData data, @Nonnull Object screen, @Nonnull Consumer<Object> consumer) {
    }

    public int getRadius(CoinChestUpgradeData data) {
        return data.getUpgradeData().getIntValue(RANGE);
    }

    @Override
    public void OnServerTick(CoinChestBlockEntity be, CoinChestUpgradeData data) {
        int radius = this.getRadius(data);
        BlockPos blockPos = be.m_58899_();
        Vector3d pos = new Vector3d((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5);
        AABB searchBox = new AABB(pos.f_86214_ - (double)radius, pos.f_86215_ - (double)radius, pos.f_86216_ - (double)radius, pos.f_86214_ + (double)radius, pos.f_86215_ + (double)radius, pos.f_86216_ + (double)radius);
        boolean playSound = false;
        for (Entity e2 : be.m_58904_().m_6249_((Entity)null, searchBox, e -> {
            ItemEntity item;
            return e instanceof ItemEntity && MoneyUtil.isCoin((item = (ItemEntity)e).m_32055_(), true);
        })) {
            ItemEntity ie = (ItemEntity)e2;
            ItemStack coinStack = ie.m_32055_();
            ItemStack leftovers = InventoryUtil.TryPutItemStack((Container)be.getStorage(), coinStack);
            if (leftovers.m_41613_() == coinStack.m_41613_()) continue;
            playSound = true;
            if (leftovers.m_41619_()) {
                ie.m_146870_();
                continue;
            }
            ie.m_32045_(leftovers);
        }
        if (playSound) {
            be.m_58904_().m_5594_(null, be.m_58899_(), (SoundEvent)ModSounds.COINS_CLINKING.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
        }
    }

    @Override
    protected List<String> getDataTags() {
        return ImmutableList.of((Object)RANGE);
    }

    @Override
    protected Object defaultTagValue(String tag) {
        if (Objects.equals(tag, RANGE)) {
            return 1;
        }
        return null;
    }

    @Override
    public List<Component> getTooltip(UpgradeType.UpgradeData data) {
        return ImmutableList.of((Object)EasyText.translatable("tooltip.lightmanscurrency.upgrade.coin_chest.magnet", data.getIntValue(RANGE)));
    }
}

