/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.client.builders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public final class ItemPositionBuilder {
    private boolean hasGlobalScale = false;
    private float globalScale = 0.0f;
    private String globalRotationType = null;
    private int globalExtraCount = 0;
    private Vector3f globalExtraOffset = null;
    private final List<PositionEntryBuilder> entries = new ArrayList<PositionEntryBuilder>();

    private ItemPositionBuilder() {
    }

    public static ItemPositionBuilder builder() {
        return new ItemPositionBuilder();
    }

    public ItemPositionBuilder withGlobalRotationType(@Nonnull String rotationType) {
        this.globalRotationType = rotationType;
        return this;
    }

    public ItemPositionBuilder withGlobalScale(float globalScale) {
        this.hasGlobalScale = true;
        this.globalScale = globalScale;
        return this;
    }

    public ItemPositionBuilder withGlobalExtraCount(int extraCount) {
        this.globalExtraCount = extraCount;
        return this;
    }

    public ItemPositionBuilder withGlobalExtraOffset(@Nonnull Vector3f extraOffset) {
        this.globalExtraOffset = extraOffset;
        return this;
    }

    public ItemPositionBuilder withEntry(@Nonnull Vector3f position) {
        this.entries.add(new PositionEntryBuilder(position, 0, null, false, 0.0f, null));
        return this;
    }

    public ItemPositionBuilder withEntry(@Nonnull Vector3f position, float scale) {
        this.entries.add(new PositionEntryBuilder(position, 0, null, true, scale, null));
        return this;
    }

    public ItemPositionBuilder withEntry(@Nonnull Vector3f position, @Nonnull String rotationType) {
        this.entries.add(new PositionEntryBuilder(position, 0, null, false, 0.0f, rotationType));
        return this;
    }

    public ItemPositionBuilder withEntry(@Nonnull Vector3f position, float scale, @Nonnull String rotationType) {
        this.entries.add(new PositionEntryBuilder(position, 0, null, true, scale, rotationType));
        return this;
    }

    public ItemPositionBuilder withEntry(@Nonnull Vector3f position, int extraCount, @Nonnull Vector3f extraOffset) {
        this.entries.add(new PositionEntryBuilder(position, extraCount, extraOffset, false, 0.0f, null));
        return this;
    }

    public ItemPositionBuilder withEntry(@Nonnull Vector3f position, int extraCount, @Nonnull Vector3f extraOffset, float scale) {
        this.entries.add(new PositionEntryBuilder(position, extraCount, extraOffset, true, scale, null));
        return this;
    }

    public ItemPositionBuilder withEntry(@Nonnull Vector3f position, int extraCount, @Nonnull Vector3f extraOffset, @Nonnull String rotationType) {
        this.entries.add(new PositionEntryBuilder(position, extraCount, extraOffset, false, 0.0f, rotationType));
        return this;
    }

    public ItemPositionBuilder withEntry(@Nonnull Vector3f position, int extraCount, @Nonnull Vector3f extraOffset, float scale, @Nonnull String rotationType) {
        this.entries.add(new PositionEntryBuilder(position, extraCount, extraOffset, true, scale, rotationType));
        return this;
    }

    @Nonnull
    public JsonObject write() {
        JsonObject json = new JsonObject();
        if (this.hasGlobalScale) {
            json.addProperty("Scale", (Number)Float.valueOf(this.globalScale));
        }
        if (this.globalRotationType != null) {
            json.addProperty("RotationType", this.globalRotationType);
        }
        if (this.globalExtraCount > 0) {
            json.addProperty("ExtraCount", (Number)this.globalExtraCount);
        }
        if (this.globalExtraOffset != null) {
            json.addProperty("offsetX", (Number)Float.valueOf(this.globalExtraOffset.m_122239_()));
            json.addProperty("offsetY", (Number)Float.valueOf(this.globalExtraOffset.m_122260_()));
            json.addProperty("offsetZ", (Number)Float.valueOf(this.globalExtraOffset.m_122269_()));
        }
        JsonArray entryList = new JsonArray();
        for (PositionEntryBuilder entry : this.entries) {
            JsonObject entryData = new JsonObject();
            JsonObject positionData = new JsonObject();
            positionData.addProperty("x", (Number)Float.valueOf(entry.position.m_122239_()));
            positionData.addProperty("y", (Number)Float.valueOf(entry.position.m_122260_()));
            positionData.addProperty("z", (Number)Float.valueOf(entry.position.m_122269_()));
            if (entry.extraCount > 0) {
                positionData.addProperty("ExtraCount", (Number)entry.extraCount);
                positionData.addProperty("offsetX", (Number)Float.valueOf(entry.extraOffset.m_122239_()));
                positionData.addProperty("offsetY", (Number)Float.valueOf(entry.extraOffset.m_122260_()));
                positionData.addProperty("offsetZ", (Number)Float.valueOf(entry.extraOffset.m_122269_()));
            }
            entryData.add("Position", (JsonElement)positionData);
            if (entry.hasCustomScale) {
                entryData.addProperty("Scale", (Number)Float.valueOf(entry.scale));
            }
            if (entry.rotationType != null) {
                entryData.addProperty("RotationType", entry.rotationType);
            }
            entryList.add((JsonElement)entryData);
        }
        json.add("Entries", (JsonElement)entryList);
        return json;
    }

    private record PositionEntryBuilder(Vector3f position, int extraCount, Vector3f extraOffset, boolean hasCustomScale, float scale, String rotationType) {
    }
}

