/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.client.generators;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBiBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.RegistryObjectBundle;
import io.github.lightman314.lightmanscurrency.datagen.client.builders.ItemPositionBuilder;
import io.github.lightman314.lightmanscurrency.datagen.util.CustomPathProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public abstract class ItemPositionProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final float MO = 1.0E-4f;
    protected final String name;
    protected final DataGenerator output;
    final CustomPathProvider blockPathProvider;
    final CustomPathProvider positionPathProvider;
    Map<ResourceLocation, BlockData> blockValues = new HashMap<ResourceLocation, BlockData>();
    Map<ResourceLocation, ItemPositionBuilder> positionValues = new HashMap<ResourceLocation, ItemPositionBuilder>();

    protected ItemPositionProvider(@Nonnull DataGenerator output, @Nonnull String modid) {
        this(output, modid, null);
    }

    protected ItemPositionProvider(@Nonnull DataGenerator output, @Nonnull String modid, @Nullable String subPack) {
        this.blockPathProvider = new CustomPathProvider(output, PackType.CLIENT_RESOURCES, "lightmanscurrency/item_position_blocks", subPack);
        this.positionPathProvider = new CustomPathProvider(output, PackType.CLIENT_RESOURCES, "lightmanscurrency/item_position_data", subPack);
        this.output = output;
        this.name = subPack != null ? modid + " (" + subPack + ")" : modid;
    }

    protected abstract void addEntries();

    protected final void addDataWithBlocks(@Nonnull ResourceLocation id, @Nonnull ItemPositionBuilder data, Object ... blocks) {
        this.addDataWithBlocks(id, id, data, blocks);
    }

    protected final void addDataWithBlocks(@Nonnull ResourceLocation id, @Nonnull ResourceLocation target, @Nonnull ItemPositionBuilder data, Object ... blocks) {
        this.addData(id, data);
        this.addBlocks(id, blocks);
    }

    protected final void addData(@Nonnull ResourceLocation id, @Nonnull ItemPositionBuilder data) {
        if (this.positionValues.containsKey(id)) {
            throw new IllegalArgumentException("Data for '" + id + "' is already defined!");
        }
        this.positionValues.put(id, data);
    }

    protected final void addBlocks(@Nonnull ResourceLocation id, Object ... blocks) {
        this.addBlocks(id, id, blocks);
    }

    protected final void addBlocks(@Nonnull ResourceLocation id, @Nonnull ResourceLocation target, Object ... blocks) {
        for (Object obj : blocks) {
            Block block;
            List values;
            if (obj instanceof RegistryObjectBiBundle) {
                RegistryObjectBiBundle bundle = (RegistryObjectBiBundle)obj;
                values = bundle.getAllSorted();
                for (Object b : values) {
                    if (!(b instanceof Block)) continue;
                    block = (Block)b;
                    this.addBlock(id, target, block);
                }
                continue;
            }
            if (obj instanceof RegistryObjectBundle) {
                RegistryObjectBundle bundle = (RegistryObjectBundle)obj;
                values = bundle.getAllSorted();
                for (Object b : values) {
                    if (!(b instanceof Block)) continue;
                    block = (Block)b;
                    this.addBlock(id, target, block);
                }
                continue;
            }
            if (obj instanceof RegistryObject) {
                RegistryObject ro = (RegistryObject)obj;
                Object object = ro.get();
                if (!(object instanceof Block)) continue;
                Block block2 = (Block)object;
                this.addBlock(id, target, block2);
                continue;
            }
            if (obj instanceof TagKey) {
                TagKey tag = (TagKey)obj;
                if (!tag.m_207645_(ForgeRegistries.BLOCKS.getRegistryKey())) continue;
                this.addBlockTag(id, target, (TagKey<Block>)((TagKey)tag.m_207647_(ForgeRegistries.BLOCKS.getRegistryKey()).orElse(null)));
                continue;
            }
            if (obj instanceof List) {
                List list = (List)obj;
                for (Object b : list) {
                    this.addBlocks(id, target, b);
                }
                continue;
            }
            if (!(obj instanceof ResourceLocation)) continue;
            ResourceLocation blockID = (ResourceLocation)obj;
            this.addBlocks(id, blockID, new Object[0]);
        }
    }

    protected final void addBlock(@Nonnull ResourceLocation id, @Nonnull Block block) {
        this.addBlock(id, id, block);
    }

    protected final void addBlock(@Nonnull ResourceLocation id, @Nonnull ResourceLocation target, @Nonnull Block block) {
        this.addBlock(id, target, ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block));
    }

    protected final void addBlock(@Nonnull ResourceLocation id, @Nonnull ResourceLocation blockID) {
        this.addBlock(id, id, blockID);
    }

    protected final void addBlock(@Nonnull ResourceLocation id, @Nonnull ResourceLocation target, @Nonnull ResourceLocation blockID) {
        BlockData data = this.blockValues.getOrDefault(id, new BlockData(target));
        if (blockID != null && !data.blocks.contains(blockID.toString())) {
            data.blocks.add(blockID.toString());
        }
        this.blockValues.put(id, data);
    }

    protected final void addBlockTag(@Nonnull ResourceLocation id, @Nullable TagKey<Block> blockTag) {
        this.addBlockTag(id, id, blockTag);
    }

    protected final void addBlockTag(@Nonnull ResourceLocation id, @Nonnull ResourceLocation target, @Nullable TagKey<Block> blockTag) {
        this.addBlockTag(id, target, blockTag != null ? blockTag.f_203868_() : null);
    }

    protected final void addBlockTag(@Nonnull ResourceLocation id, @Nullable ResourceLocation blockTag) {
        this.addBlockTag(id, id, blockTag);
    }

    protected final void addBlockTag(@Nonnull ResourceLocation id, @Nonnull ResourceLocation target, @Nullable ResourceLocation blockTag) {
        BlockData data = this.blockValues.getOrDefault(id, new BlockData(target));
        if (blockTag != null && !data.blocks.contains("#" + blockTag)) {
            data.blocks.add("#" + blockTag);
        }
        this.blockValues.put(id, data);
    }

    public void m_6865_(@Nonnull HashCache cache) {
        this.blockValues.clear();
        this.positionValues.clear();
        this.addEntries();
        this.positionValues.forEach((id, data) -> {
            JsonObject dataJson = data.write();
            Path path = this.positionPathProvider.json((ResourceLocation)id);
            if (path != null) {
                try {
                    DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)dataJson, (Path)path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.blockValues.forEach((id, blocks) -> {
            JsonObject blockJson = new JsonObject();
            JsonArray blockList = new JsonArray();
            blockJson.addProperty("target", blocks.target.toString());
            for (String block : blocks.blocks) {
                blockList.add(block);
            }
            blockJson.add("values", (JsonElement)blockList);
            Path path = this.blockPathProvider.json((ResourceLocation)id);
            if (path != null) {
                try {
                    DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)blockJson, (Path)path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Nonnull
    public String m_6055_() {
        return "LightmansCurrency Item Positions: " + this.name;
    }

    private static class BlockData {
        public final ResourceLocation target;
        public final List<String> blocks = new ArrayList<String>();

        public BlockData(@Nonnull ResourceLocation target) {
            this.target = target;
        }
    }
}

