/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.common.loot.packs;

import io.github.lightman314.lightmanscurrency.common.loot.ConfigItemTier;
import io.github.lightman314.lightmanscurrency.common.loot.LCLootTables;
import io.github.lightman314.lightmanscurrency.common.loot.entries.ConfigLoot;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class EntityAddonLoot
implements Consumer<BiConsumer<ResourceLocation, LootTable.Builder>> {
    @Override
    public void accept(@Nonnull BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        LootPool.Builder t1 = EntityAddonLoot.GenerateEntityCoinPool(ConfigItemTier.T1, 1.0f, 10.0f, 0.75f);
        LootPool.Builder t2 = EntityAddonLoot.GenerateEntityCoinPool(ConfigItemTier.T2, 1.0f, 5.0f, 0.5f);
        LootPool.Builder t3 = EntityAddonLoot.GenerateEntityCoinPool(ConfigItemTier.T3, 1.0f, 5.0f, 0.25f);
        LootPool.Builder t4 = EntityAddonLoot.GenerateEntityCoinPool(ConfigItemTier.T4, 1.0f, 3.0f, 0.1f);
        LootPool.Builder t5 = EntityAddonLoot.GenerateEntityCoinPool(ConfigItemTier.T5, 1.0f, 3.0f, 0.05f);
        LootPool.Builder t6 = EntityAddonLoot.GenerateEntityCoinPool(ConfigItemTier.T6, 1.0f, 3.0f, 0.025f);
        consumer.accept(LCLootTables.ENTITY_DROPS_T1, LootTable.m_79147_().m_79165_(LootContextParamSets.f_81415_).m_79161_(t1));
        consumer.accept(LCLootTables.ENTITY_DROPS_T2, LootTable.m_79147_().m_79161_(t1).m_79161_(t2));
        consumer.accept(LCLootTables.ENTITY_DROPS_T3, LootTable.m_79147_().m_79161_(t1).m_79161_(t2).m_79161_(t3));
        consumer.accept(LCLootTables.ENTITY_DROPS_T4, LootTable.m_79147_().m_79161_(t1).m_79161_(t2).m_79161_(t3).m_79161_(t4));
        consumer.accept(LCLootTables.ENTITY_DROPS_T5, LootTable.m_79147_().m_79161_(t1).m_79161_(t2).m_79161_(t3).m_79161_(t4).m_79161_(t5));
        consumer.accept(LCLootTables.ENTITY_DROPS_T6, LootTable.m_79147_().m_79161_(t1).m_79161_(t2).m_79161_(t3).m_79161_(t4).m_79161_(t5).m_79161_(t6));
        consumer.accept(LCLootTables.BOSS_DROPS_T1, LootTable.m_79147_().m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T1)));
        consumer.accept(LCLootTables.BOSS_DROPS_T2, LootTable.m_79147_().m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T1)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T2)));
        consumer.accept(LCLootTables.BOSS_DROPS_T3, LootTable.m_79147_().m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T1)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T2)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T3)));
        consumer.accept(LCLootTables.BOSS_DROPS_T4, LootTable.m_79147_().m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T1)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T2)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T3)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T4)));
        consumer.accept(LCLootTables.BOSS_DROPS_T5, LootTable.m_79147_().m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T1)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T2)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T3)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T4)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T5)));
        consumer.accept(LCLootTables.BOSS_DROPS_T6, LootTable.m_79147_().m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T1)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T2)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T3)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T4)).m_79161_(EntityAddonLoot.BossPool(ConfigItemTier.T5)).m_79161_(EntityAddonLoot.GenerateEntityCoinPool(ConfigItemTier.T6, 1.0f, 5.0f, 1.0f)));
    }

    private static LootPool.Builder BossPool(ConfigItemTier tier) {
        return EntityAddonLoot.GenerateEntityCoinPool(tier, 10.0f, 30.0f, 1.0f);
    }

    private static LootPool.Builder GenerateEntityCoinPool(ConfigItemTier tier, float min, float max, float chance) {
        LootPool.Builder lootPoolBuilder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)ConfigLoot.lootTableTier(tier).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))));
        if (chance < 1.0f) {
            lootPoolBuilder.m_6509_(LootItemRandomChanceWithLootingCondition.m_81963_((float)chance, (float)0.01f));
        }
        return lootPoolBuilder;
    }
}

