/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen.util;

import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;

public class CustomPathProvider {
    private final Path root;
    private final String kind;

    public CustomPathProvider(@Nonnull DataGenerator output, @Nonnull PackType target, @Nonnull String kind) {
        this(output, target, kind, null);
    }

    public CustomPathProvider(@Nonnull DataGenerator output, @Nonnull PackType target, @Nonnull String kind, @Nullable String subPack) {
        this.root = subPack != null ? output.m_123916_().resolve(subPack).resolve(CustomPathProvider.getDirectory(target)) : output.m_123916_().resolve(CustomPathProvider.getDirectory(target));
        this.kind = kind;
    }

    public Path file(@Nonnull ResourceLocation location, @Nonnull String extension) {
        return this.root.resolve(location.m_135827_()).resolve(this.kind).resolve(location.m_135815_() + "." + extension);
    }

    public Path json(@Nonnull ResourceLocation location) {
        return this.file(location, "json");
    }

    private static String getDirectory(@Nonnull PackType target) {
        return switch (target) {
            default -> throw new IncompatibleClassChangeError();
            case PackType.CLIENT_RESOURCES -> "assets";
            case PackType.SERVER_DATA -> "data";
        };
    }
}

