/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.curios;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.common.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.common.items.PortableATMItem;
import io.github.lightman314.lightmanscurrency.common.items.PortableTerminalItem;
import io.github.lightman314.lightmanscurrency.common.menus.wallet.WalletMenuBase;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.capability.CurioItemCapability;

public class LCCurios {
    public static final String WALLET_SLOT = "wallet";

    private static ICuriosItemHandler lazyGetCuriosHelper(LivingEntity entity) {
        LazyOptional optional = CuriosApi.getCuriosHelper().getCuriosHandler(entity);
        return optional.isPresent() ? (ICuriosItemHandler)optional.orElseGet(() -> {
            throw new RuntimeException("Unexpected error occurred!");
        }) : null;
    }

    public static boolean hasWalletSlot(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        try {
            ICuriosItemHandler curiosHelper = LCCurios.lazyGetCuriosHelper(entity);
            if (curiosHelper != null) {
                ICurioStacksHandler stacksHandler = curiosHelper.getStacksHandler(WALLET_SLOT).orElse(null);
                return stacksHandler != null && stacksHandler.getSlots() > 0;
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error checking curios wallet slot validity.", t);
        }
        return false;
    }

    public static ItemStack getCuriosWalletContents(LivingEntity entity) {
        try {
            ICurioStacksHandler stacksHandler;
            ICuriosItemHandler curiosHelper = LCCurios.lazyGetCuriosHelper(entity);
            if (curiosHelper != null && (stacksHandler = (ICurioStacksHandler)curiosHelper.getStacksHandler(WALLET_SLOT).orElse(null)) != null && stacksHandler.getSlots() > 0) {
                return stacksHandler.getStacks().getStackInSlot(0);
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error getting wallet from curios wallet slot.", t);
        }
        return ItemStack.f_41583_;
    }

    public static void setCuriosWalletContents(LivingEntity entity, ItemStack wallet) {
        try {
            ICurioStacksHandler stacksHandler;
            ICuriosItemHandler curiosHelper = LCCurios.lazyGetCuriosHelper(entity);
            if (curiosHelper != null && (stacksHandler = (ICurioStacksHandler)curiosHelper.getStacksHandler(WALLET_SLOT).orElse(null)) != null && stacksHandler.getSlots() > 0) {
                stacksHandler.getStacks().setStackInSlot(0, wallet);
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error placing wallet into the curios wallet slot.", t);
        }
    }

    public static boolean getCuriosWalletVisibility(LivingEntity entity) {
        try {
            ICurioStacksHandler stacksHandler;
            ICuriosItemHandler curiosHelper = LCCurios.lazyGetCuriosHelper(entity);
            if (curiosHelper != null && (stacksHandler = (ICurioStacksHandler)curiosHelper.getStacksHandler(WALLET_SLOT).orElse(null)) != null && stacksHandler.getSlots() > 0) {
                return (Boolean)stacksHandler.getRenders().get(0);
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error getting wallet slot visibility from curios.", t);
        }
        return false;
    }

    public static boolean hasPortableTerminal(LivingEntity entity) {
        try {
            ICuriosItemHandler curiosHelper = LCCurios.lazyGetCuriosHelper(entity);
            if (curiosHelper != null) {
                for (Map.Entry entry : curiosHelper.getCurios().entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    if (stacksHandler == null) continue;
                    IDynamicStackHandler sh = stacksHandler.getStacks();
                    for (int i = 0; i < sh.getSlots(); ++i) {
                        if (!(sh.getStackInSlot(i).m_41720_() instanceof PortableTerminalItem)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error checking for Portable Terminal from curios.", t);
        }
        return false;
    }

    public static boolean hasPortableATM(LivingEntity entity) {
        try {
            ICuriosItemHandler curiosHelper = LCCurios.lazyGetCuriosHelper(entity);
            if (curiosHelper != null) {
                for (Map.Entry entry : curiosHelper.getCurios().entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    if (stacksHandler == null) continue;
                    IDynamicStackHandler sh = stacksHandler.getStacks();
                    for (int i = 0; i < sh.getSlots(); ++i) {
                        if (!(sh.getStackInSlot(i).m_41720_() instanceof PortableATMItem)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error checking for Portable Terminal from curios.", t);
        }
        return false;
    }

    @Nullable
    public static ItemStack getMoneyMendingItem(LivingEntity entity) {
        try {
            ICuriosItemHandler curiosHelper = LCCurios.lazyGetCuriosHelper(entity);
            if (curiosHelper != null) {
                for (Map.Entry entry : curiosHelper.getCurios().entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    if (stacksHandler == null) continue;
                    IDynamicStackHandler sh = stacksHandler.getStacks();
                    for (int i = 0; i < sh.getSlots(); ++i) {
                        ItemStack item = sh.getStackInSlot(i);
                        if (!EnchantmentHelper.m_44831_((ItemStack)item).containsKey(ModEnchantments.MONEY_MENDING.get())) continue;
                        return item;
                    }
                }
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error checking for Money Mending item from curios.", t);
        }
        return null;
    }

    public static ICapabilityProvider createWalletProvider(final ItemStack stack) {
        try {
            return CurioItemCapability.createProvider((ICurio)new ICurio(){

                public ItemStack getStack() {
                    return stack;
                }

                @Nonnull
                public ICurio.SoundInfo getEquipSound(SlotContext context) {
                    return new ICurio.SoundInfo(SoundEvents.f_11678_, 1.0f, 1.0f);
                }

                public boolean canEquipFromUse(SlotContext context) {
                    return false;
                }

                public boolean canSync(SlotContext context) {
                    return true;
                }

                public boolean canEquip(SlotContext context) {
                    return context.entity() instanceof Player;
                }

                public boolean canUnequip(SlotContext context) {
                    LivingEntity livingEntity = context.entity();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        livingEntity = player.f_36096_;
                        if (livingEntity instanceof WalletMenuBase) {
                            WalletMenuBase menu = (WalletMenuBase)livingEntity;
                            return !menu.isEquippedWallet();
                        }
                    }
                    return true;
                }

                @Nonnull
                public ICurio.DropRule getDropRule(SlotContext context, DamageSource source, int lootingLevel, boolean recentlyHit) {
                    GameRules.BooleanValue keepWallet = ModGameRules.getCustomValue(context.entity().f_19853_, ModGameRules.KEEP_WALLET);
                    if (keepWallet != null && keepWallet.m_46223_()) {
                        return ICurio.DropRule.ALWAYS_KEEP;
                    }
                    return ICurio.DropRule.DEFAULT;
                }
            });
        }
        catch (Throwable t) {
            return null;
        }
    }
}

