/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.integration.ftbchunks;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class LCFTBChunksIntegration {
    public static void setup() {
        MinecraftForge.EVENT_BUS.register(LCFTBChunksIntegration.class);
    }

    public static boolean canBuyClaims() {
        return (Boolean)Config.SERVER.ftbChunksAllowClaimPurchase.get();
    }

    public static boolean canBuyForceload() {
        return (Boolean)Config.SERVER.ftbChunksAllowForceloadPurchase.get();
    }

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder lcftbcommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lcftb").requires(stack -> stack.m_81373_() instanceof Player)).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"buy").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"claim").executes(c -> LCFTBChunksIntegration.tryBuyClaim((CommandContext<CommandSourceStack>)c, 1))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> LCFTBChunksIntegration.tryBuyClaim((CommandContext<CommandSourceStack>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"count")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"forceload").executes(c -> LCFTBChunksIntegration.tryBuyForceload((CommandContext<CommandSourceStack>)c, 1))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> LCFTBChunksIntegration.tryBuyForceload((CommandContext<CommandSourceStack>)c, IntegerArgumentType.getInteger((CommandContext)c, (String)"count"))))))).then(Commands.m_82127_((String)"info").executes(LCFTBChunksIntegration::info));
        dispatcher.register(lcftbcommand);
    }

    private static int info(CommandContext<CommandSourceStack> commandContext) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        ServerPlayer player = source.m_81375_();
        FTBChunksTeamData data = FTBChunksAPI.getManager().getPersonalData(player);
        if (data == null) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.fail.nodata", new Object[0]));
            return 0;
        }
        int count = 0;
        if (LCFTBChunksIntegration.canBuyClaims()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.claims.info", data.getExtraClaimChunks(), Config.SERVER.ftbChunksMaxClaimCount.get()), false);
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.info.price", Config.SERVER.ftbChunksClaimPrice.get().getComponent(EasyText.translatable("command.lightmanscurrency.lcftb.invalid_price", new Object[0]))), false);
            ++count;
        }
        if (LCFTBChunksIntegration.canBuyForceload()) {
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.forceload.info", data.getExtraForceLoadChunks(), Config.SERVER.ftbChunksMaxForceloadCount.get()), false);
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.info.price", Config.SERVER.ftbChunksForceloadPrice.get().getComponent(EasyText.translatable("command.lightmanscurrency.lcftb.invalid_price", new Object[0]))), false);
            ++count;
        }
        if (count <= 0) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.info.disabled.all", new Object[0]));
        }
        return count;
    }

    private static int tryBuyClaim(CommandContext<CommandSourceStack> commandContext, int count) throws CommandSyntaxException {
        int boughtCount;
        boolean invalidPrice;
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        if (!LCFTBChunksIntegration.canBuyClaims()) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.claims.fail.disabled", new Object[0]));
            return 0;
        }
        ServerPlayer player = source.m_81375_();
        FTBChunksTeamData personalData = FTBChunksAPI.getManager().getPersonalData(player.m_142081_());
        if (personalData == null) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.fail.nodata", new Object[0]));
            return 0;
        }
        CoinValue price = Config.SERVER.ftbChunksClaimPrice.get();
        boolean hitLimit = false;
        boolean bl = invalidPrice = !price.hasAny();
        for (boughtCount = 0; boughtCount < count && !invalidPrice; ++boughtCount) {
            int allowedToBuy = (Integer)Config.SERVER.ftbChunksMaxClaimCount.get() - personalData.getExtraClaimChunks() - boughtCount;
            if (allowedToBuy <= 0) {
                hitLimit = true;
                break;
            }
            if (!MoneyUtil.ProcessPayment(null, (Player)player, price)) break;
        }
        if (boughtCount > 0) {
            personalData.extraClaimChunks = personalData.getExtraClaimChunks() + boughtCount;
            LCFTBChunksIntegration.setDataChanged(personalData, player);
            if (hitLimit) {
                EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.claims.limit_reached", Config.SERVER.ftbChunksMaxClaimCount.get()), true);
            }
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.claims.success", boughtCount), true);
            return boughtCount;
        }
        if (invalidPrice) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.fail.invalid_price", new Object[0]));
        } else if (hitLimit) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.claims.limit_reached", Config.SERVER.ftbChunksMaxClaimCount.get()));
        } else {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.claims.fail.cantafford", new Object[0]));
        }
        return 0;
    }

    private static int tryBuyForceload(CommandContext<CommandSourceStack> commandContext, int count) throws CommandSyntaxException {
        int boughtCount;
        boolean invalidPrice;
        CommandSourceStack source = (CommandSourceStack)commandContext.getSource();
        if (!LCFTBChunksIntegration.canBuyForceload()) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.forceload.fail.disabled", new Object[0]));
            return 0;
        }
        ServerPlayer player = source.m_81375_();
        FTBChunksTeamData data = FTBChunksAPI.getManager().getPersonalData(player);
        if (data == null) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.fail.nodata", new Object[0]));
            return 0;
        }
        CoinValue price = Config.SERVER.ftbChunksForceloadPrice.get();
        boolean hitLimit = false;
        boolean bl = invalidPrice = !price.hasAny();
        for (boughtCount = 0; boughtCount < count && !invalidPrice; ++boughtCount) {
            int allowedToBuy = (Integer)Config.SERVER.ftbChunksMaxForceloadCount.get() - data.getExtraForceLoadChunks() - boughtCount;
            if (allowedToBuy <= 0) {
                hitLimit = true;
                break;
            }
            if (!MoneyUtil.ProcessPayment(null, (Player)player, price)) break;
        }
        if (boughtCount > 0) {
            data.extraForceLoadChunks = data.getExtraForceLoadChunks() + boughtCount;
            LCFTBChunksIntegration.setDataChanged(data, player);
            if (hitLimit) {
                EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.forceload.limit_reached", Config.SERVER.ftbChunksMaxClaimCount.get()), true);
            }
            EasyText.sendCommandSucess(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.forceload.success", boughtCount), true);
            return boughtCount;
        }
        if (invalidPrice) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.fail.invalid_price", new Object[0]));
        } else if (hitLimit) {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.forceload.limit_reached", Config.SERVER.ftbChunksMaxClaimCount.get()));
        } else {
            EasyText.sendCommandFail(source, (Component)EasyText.translatable("command.lightmanscurrency.lcftb.forceload.fail.cantafford", new Object[0]));
        }
        return 0;
    }

    private static void setDataChanged(FTBChunksTeamData data, ServerPlayer player) {
        data.save();
        FTBChunksTeamData teamData = FTBChunksAPI.getManager().getData(player);
        teamData.updateLimits();
        SendGeneralDataPacket.send((FTBChunksTeamData)teamData, (ServerPlayer)player);
    }
}

